/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import java.util.Date;
import kd.bos.id.Base36Coder;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDRange;
import kd.bos.id.IDService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public interface ID {
    public static long genLongId() {
        return IDService.get().genLongId();
    }

    public static long[] genLongIds(int count) {
        return IDService.get().genLongIds(count);
    }

    public static String genStringId() {
        return Base39Coder.toString(ID.genLongId());
    }

    public static String[] genStringIds(int count) {
        long[] lids = ID.genLongIds(count);
        String[] sids = new String[count];
        for (int i = 0; i < count; ++i) {
            sids[i] = Base39Coder.toString(lids[i]);
        }
        return sids;
    }

    public static String toStringId(long id) {
        return Base39Coder.toString(id);
    }

    public static long toLongId(String id) {
        return Base39Coder.toLong(id);
    }

    public static Date getCreateTime(long id) {
        return IDService.get().getCreateTime(id);
    }

    public static Date getCreateTime(String id) {
        return IDService.get().getCreateTime(Base39Coder.toLong(id));
    }

    public static IDRange getIDRangeOfDay(Date date) {
        return IDService.get().getIDRangeOfDay(date);
    }

    public static String longTo36Radix(long id) {
        return Base36Coder.toString(id);
    }

    public static long longFrom36Radix(String idOf36Radix) {
        return Base36Coder.toLong(idOf36Radix);
    }
}

