/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.bundle.Resources;
import kd.bos.id.IDRange;
import kd.bos.id.IDServiceConf2ZK;
import kd.bos.id.IDServiceLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IDGenner {
    private static final Log log = LogFactory.getLog(IDGenner.class);
    private static final int MIN_TIME_BITS = 39;
    private static final int DEFAULT_WORKER_BITS = 13;
    private static final int DEFAULT_SEQUENCE_BITS = 10;
    private static final String DEFAULT_EPOCH_DATE = "2017-01-01";
    private static final int MAX_WORKER_SEQUENCE_BITS = 24;
    public static final int default_max_worker_id = IDGenner.getMaxWorkerId(13);
    private final SimpleDateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat sdf_ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final int workerBits;
    private final int sequenceBits;
    private final int timeBits;
    private final int clusterNumberBits;
    private final long epoch;
    private final int workerId;
    private int sequence = 0;
    private final int shiftTime;
    private final int shiftWorker;
    private final int sequenceMask;
    private final long tolerantClockBackTimestamp;
    private long lastTimestamp = -1L;
    private long lastId = -1L;
    private final String desc;
    private boolean useForwardTime;

    public static int getMaxWorkerId(int workerBits) {
        if (IDServiceConf2ZK.isEnableDifferentCluster()) {
            int clusterNumberBits = IDServiceConf2ZK.getClusterNumberBits();
            return (1 << workerBits - clusterNumberBits) - 1;
        }
        return (1 << workerBits) - 1;
    }

    public IDGenner(int workerId, long tolerantClockBackTimestamp) {
        this(workerId, tolerantClockBackTimestamp, null);
    }

    public IDGenner(int workerId, long tolerantClockBackTimestamp, String desc) {
        this(workerId, tolerantClockBackTimestamp, 13, 10, DEFAULT_EPOCH_DATE, desc);
    }

    public IDGenner(int workerId, long tolerantClockBackTimestamp, String desc, boolean useForwardTime) {
        this(workerId, tolerantClockBackTimestamp, 13, 10, DEFAULT_EPOCH_DATE, desc, useForwardTime);
    }

    protected IDGenner(int workerId, long tolerantClockBackTimestamp, int workerBits, int sequenceBits, String epochDate, String startupDesc) {
        this(workerId, tolerantClockBackTimestamp, workerBits, sequenceBits, epochDate, startupDesc, false);
    }

    protected IDGenner(int workerId, long tolerantClockBackTimestamp, int workerBits, int sequenceBits, String epochDate, String startupDesc, boolean useForwardTime) {
        this.tolerantClockBackTimestamp = tolerantClockBackTimestamp;
        this.workerId = workerId;
        int maxWorkerId = IDGenner.getMaxWorkerId(workerBits);
        if (this.workerId < 0 || this.workerId > maxWorkerId) {
            throw new IllegalArgumentException(this.logPrefix() + Resources.getString((String)"bos-id", (String)"IDGenner_0", (Object[])new Object[0]) + maxWorkerId);
        }
        this.workerBits = workerBits;
        this.clusterNumberBits = IDServiceConf2ZK.getClusterNumberBits();
        this.sequenceBits = sequenceBits;
        this.shiftTime = workerBits + sequenceBits;
        this.shiftWorker = sequenceBits;
        this.sequenceMask = 0xFFFFFFFF ^ -1 << sequenceBits;
        this.timeBits = 63 - workerBits - sequenceBits;
        this.useForwardTime = useForwardTime;
        if (this.timeBits < 39) {
            throw new IllegalArgumentException(this.logPrefix() + Resources.get((String)"bos-id", (String)"IDGenner_1", (String)"\u65f6\u95f4\u6233\u4f4d\u6570\u4e0d\u5e94\u5c0f\u4e8e%1$s(\u5b9e\u9645%2$s), workerBits\u4e0esequenceBits\u4e4b\u548c\u5e94<=%3$s.", (Object[])new Object[]{39, this.timeBits, 24}));
        }
        try {
            this.epoch = this.sdf_date.parse(epochDate).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(Resources.getString((String)"bos-id", (String)"IDGenner_4", (Object[])new Object[0]), e);
        }
        this.desc = "[" + this + "]epoch:" + this.sdf_date.format(this.epoch);
        IDServiceLog.debug(this.desc);
    }

    private String logPrefix() {
        return "[workerId:" + this.workerId + "] ";
    }

    private long createId(long timestamp) {
        if (IDServiceConf2ZK.isEnableDifferentCluster()) {
            int clusterNumber = IDServiceConf2ZK.getClusterNumber();
            return timestamp - this.epoch << this.shiftTime | (long)this.workerId << this.shiftWorker + this.clusterNumberBits | (long)clusterNumber << this.shiftWorker | (long)this.sequence;
        }
        return timestamp - this.epoch << this.shiftTime | (long)this.workerId << this.shiftWorker | (long)this.sequence;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == (timestamp = this.checkClockBackwards(timestamp))) {
            this.sequence = this.sequence + 1 & this.sequenceMask;
            if (this.sequence == 0) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else if (this.sequence != 0) {
            this.sequence = 0;
        }
        this.lastTimestamp = timestamp;
        this.lastId = this.createId(timestamp);
        return this.lastId;
    }

    private long checkClockBackwards(long timestamp) {
        if (timestamp < this.lastTimestamp) {
            String warnMsg = String.format("Clock rollback is detected on current node, currenttime:%1s, lasttime:%2s, lastId:%3s", timestamp, this.lastTimestamp, this.lastId);
            log.warn(warnMsg);
            if (!this.useForwardTime) {
                boolean fixedByWait = true;
                long offset = this.lastTimestamp - timestamp;
                if (offset <= this.tolerantClockBackTimestamp && this.tolerantClockBackTimestamp > 0L) {
                    try {
                        this.wait(this.tolerantClockBackTimestamp << 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    timestamp = this.timeGen();
                    if (timestamp < this.lastTimestamp) {
                        fixedByWait = false;
                    }
                }
                if (!fixedByWait) {
                    throw new IllegalStateException(this.logPrefix() + Resources.getString((String)"bos-id", (String)"IDGenner_5", (Object[])new Object[0]) + offset + Resources.getString((String)"bos-id", (String)"IDGenner_6", (Object[])new Object[0]) + this.sdf_ts.format(timestamp) + "\u3002");
                }
            } else {
                timestamp = this.lastTimestamp + 1000L;
            }
        }
        return timestamp;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.workerId;
    }

    public Date getCreateTime(long id) {
        return new Date((id >> this.workerBits + this.sequenceBits) + this.epoch);
    }

    public IDRange getIDRangeOfDay(Date date) {
        long max;
        long min;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        if (IDServiceConf2ZK.isEnableDifferentCluster()) {
            int clusterNumber = IDServiceConf2ZK.getClusterNumber();
            min = c.getTimeInMillis() - this.epoch << this.shiftTime | (long)clusterNumber << this.shiftWorker;
        } else {
            min = c.getTimeInMillis() - this.epoch << this.shiftTime;
        }
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        if (IDServiceConf2ZK.isEnableDifferentCluster()) {
            int clusterNumber = IDServiceConf2ZK.getClusterNumber();
            max = c.getTimeInMillis() - this.epoch << this.shiftTime | (long)default_max_worker_id << this.shiftWorker + this.clusterNumberBits | (long)clusterNumber << this.shiftWorker | (long)this.sequenceMask;
        } else {
            max = c.getTimeInMillis() - this.epoch << this.shiftTime | (long)default_max_worker_id << this.shiftWorker | (long)this.sequenceMask;
        }
        return new IDRange(min, max);
    }
}

