/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import kd.bos.bundle.Resources;
import kd.bos.dlock.CrossCluster;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDServiceConf;
import kd.bos.id.worker.AssignerType;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public final class IDServiceAssignerConfig {
    private static final String ID_SERVICE_ASSIGNER_TYPE = "IDService.assigner.type";
    private static final String ID_SERVICE_ASSIGNER_REDIS = "IDService.assigner.redis";
    private static String workerIdAssignerType = null;
    private int logStatusInterval = 3600000;
    private long tolerantClockBackTimestamp = 5000L;
    private String rootPath = "/";
    private String server;
    private int groupWorkers = 1;
    private int intIdMinValue = 100001;
    private int batchGenIntSize = 100;

    private IDServiceAssignerConfig() {
    }

    public static IDServiceAssignerConfig createAssignerConfig() {
        if (StringUtils.isEmpty((String)workerIdAssignerType)) {
            return null;
        }
        IDServiceAssignerConfig config = new IDServiceAssignerConfig();
        AssignerType assignerType = AssignerType.from(workerIdAssignerType);
        switch (assignerType) {
            case REDIS_ASSIGNER: {
                IDServiceAssignerConfig.initServer(config);
                break;
            }
            case DB_ASSIGNER: {
                break;
            }
            default: {
                throw new KDException(BosErrorCode.bosId, new Object[]{String.format("unsupported assigner type name=%s", assignerType.getTypeName())});
            }
        }
        if (CrossCluster.getClusterNameForPath() != null) {
            config.setRootPath(IDServiceAssignerConfig.getRootPath());
        }
        String worker = System.getProperty("IDService.worker", "0");
        int workers = 0;
        if (worker != null && worker.matches("\\d+")) {
            workers = Integer.parseInt(worker);
        }
        if (workers > 0) {
            config.setGroupWorkers(workers);
        }
        return config;
    }

    void setRootPath(String rootPath) {
        if (rootPath == null || rootPath.length() == 0) {
            rootPath = "/";
        } else if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        this.rootPath = rootPath;
    }

    private static void initServer(IDServiceAssignerConfig config) {
        String redis = System.getProperty(ID_SERVICE_ASSIGNER_REDIS);
        if (redis == null) {
            redis = System.getProperty("redis.serversForSession");
        }
        config.setServer(redis);
    }

    public String getServer() {
        return this.server;
    }

    void setServer(String server) {
        this.server = server;
    }

    private static String getRootPath() {
        return "/" + CrossCluster.getClusterNameForPath() + "/runtime/ids";
    }

    public String getWorkerIdAssignerType() {
        return workerIdAssignerType;
    }

    public long getTolerantClockBackTimestamp() {
        return this.tolerantClockBackTimestamp;
    }

    int getLogStatusInterval() {
        return this.logStatusInterval;
    }

    public int getBatchGenIntSize() {
        return this.batchGenIntSize;
    }

    public int getGroupWorkers() {
        return this.groupWorkers;
    }

    void setGroupWorkers(int groupWorkers) {
        if (groupWorkers < 1 || groupWorkers > this.getMaxWorkerCount()) {
            throw new IllegalArgumentException(Resources.get((String)"bos-id", (String)"IDServiceConf_0", (String)"Workers %s\uff0c\u5141\u8bb8\u8303\u56f4\u4e3a\uff1a1-", (Object[])new Object[]{groupWorkers, this.getMaxWorkerCount()}));
        }
        this.groupWorkers = groupWorkers;
    }

    public int getMaxWorkerCount() {
        return IDServiceConf.MAX_WORKER_COUNT;
    }

    public int getIntIdMinValue() {
        return this.intIdMinValue;
    }

    void setIntIdMinValue(int intIdMinValue) {
        this.intIdMinValue = intIdMinValue;
    }

    public String getLongLockPath() {
        return this.rootPath + "l" + "/" + "k";
    }

    public String getLongWorkerListPath() {
        return this.rootPath + "l" + "/" + "w";
    }

    public String getLongWorkerTimePath() {
        return this.rootPath + "l" + "/" + "t";
    }

    public String getLongWorkerTimePath(int wokerId) {
        return this.rootPath + "l" + "/" + "t" + "/" + wokerId;
    }

    public String getIntLockPath(String tenantId, String tablename) {
        return this.rootPath + "i" + "/" + tenantId.toLowerCase() + "/" + tablename.toLowerCase() + "/" + "k";
    }

    public String getIntValuePath(String tenantId, String tablename) {
        return this.rootPath + "i" + "/" + tenantId.toLowerCase() + "/" + tablename.toLowerCase() + "/" + "v";
    }

    String getStatus() {
        StringBuilder ss = new StringBuilder(256);
        ss.append("    rootPath=").append(this.rootPath);
        ss.append("\r\n    groupWorkers=").append(this.groupWorkers);
        ss.append("\r\n    logStatusInterval=").append(this.logStatusInterval).append("ms");
        if (!StringUtils.isEmpty((String)workerIdAssignerType)) {
            ss.append("\r\n    workerIdAssignerType=").append(workerIdAssignerType);
        }
        return ss.toString();
    }

    static {
        ConfigurationUtil.observeString((String)ID_SERVICE_ASSIGNER_TYPE, (String)"", v -> {
            workerIdAssignerType = v;
        });
    }
}

