/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import kd.bos.bundle.Resources;
import kd.bos.id.IDClockBackStrategy;
import kd.bos.id.IDGenner;
import kd.bos.lock.DLockProvider;

class IDServiceConf {
    static final int MAX_WORKER_COUNT = IDGenner.default_max_worker_id + 1;
    static final String NODE_NAME_LOCK = "k";
    static final String NODE_NAME_VALUE = "v";
    static final String NODE_NAME_WORKERLIST = "w";
    static final String NODE_NAME_WORKERTIME = "t";
    static final String LONG_KEY_NODE_PATH = "l";
    static final String INT_KEY_NODE_PATH = "i";
    private IDClockBackStrategy clockBackStrategy = IDClockBackStrategy.abandon_then_restart;
    private DLockProvider lockProvider = DLockProvider.apache_curator_framework;
    private String server = "localhost:2181";
    private int sessionReconnectCount = 3;
    private int sessionTimeout = 5000;
    private int logStatusInterval = 3600000;
    private String rootPath = "/";
    private int groupWorkers = 1;
    private int intIdMinValue = 100001;
    private int batchGenIntSize = 100;

    static IDServiceConf createDefault() {
        return new IDServiceConf();
    }

    private IDServiceConf() {
    }

    DLockProvider getLockProvider() {
        return this.lockProvider;
    }

    void setLockProvider(DLockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    int getSessionTimeout() {
        return this.sessionTimeout;
    }

    void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    int getSessionReconnectCount() {
        return this.sessionReconnectCount;
    }

    void setSessionReconnectCount(int sessionReconnectCount) {
        this.sessionReconnectCount = sessionReconnectCount;
    }

    int getBatchGenIntSize() {
        return this.batchGenIntSize;
    }

    void setBatchGenIntSize(int batchGenIntSize) {
        this.batchGenIntSize = batchGenIntSize;
    }

    int getGroupWorkers() {
        return this.groupWorkers;
    }

    void setGroupWorkers(int groupWorkers) {
        if (groupWorkers < 1 || groupWorkers > this.getMaxWorkerCount()) {
            throw new IllegalArgumentException(Resources.get((String)"bos-id", (String)"IDServiceConf_0", (String)"Workers %s\uff0c\u5141\u8bb8\u8303\u56f4\u4e3a\uff1a1-", (Object[])new Object[]{groupWorkers, this.getMaxWorkerCount()}));
        }
        this.groupWorkers = groupWorkers;
    }

    String getRootPath() {
        return this.rootPath;
    }

    void setRootPath(String rootPath) {
        if (rootPath == null || rootPath.length() == 0) {
            rootPath = "/";
        } else if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        this.rootPath = rootPath;
    }

    String getServer() {
        return this.server;
    }

    void setServer(String server) {
        this.server = server;
    }

    int getLogStatusInterval() {
        return this.logStatusInterval;
    }

    void setLogStatusInterval(int logStatusInterval) {
        this.logStatusInterval = logStatusInterval;
    }

    int getMaxWorkerCount() {
        return MAX_WORKER_COUNT;
    }

    int getIntIdMinValue() {
        return this.intIdMinValue;
    }

    void setIntIdMinValue(int intIdMinValue) {
        this.intIdMinValue = intIdMinValue;
    }

    IDClockBackStrategy getClockBackStrategy() {
        return this.clockBackStrategy;
    }

    void setClockBackStrategy(IDClockBackStrategy clockBackStrategy) {
        this.clockBackStrategy = clockBackStrategy;
    }

    String getLongLockPath() {
        return this.rootPath + LONG_KEY_NODE_PATH + "/" + NODE_NAME_LOCK;
    }

    String getLongWorkerListPath() {
        return this.rootPath + LONG_KEY_NODE_PATH + "/" + NODE_NAME_WORKERLIST;
    }

    String getLongWorkerTimePath() {
        return this.rootPath + LONG_KEY_NODE_PATH + "/" + NODE_NAME_WORKERTIME;
    }

    String getLongWorkerTimePath(int wokerId) {
        return this.rootPath + LONG_KEY_NODE_PATH + "/" + NODE_NAME_WORKERTIME + "/" + wokerId;
    }

    String getIntLockPath(String tenantId, String tablename) {
        return this.rootPath + INT_KEY_NODE_PATH + "/" + tenantId.toLowerCase() + "/" + tablename.toLowerCase() + "/" + NODE_NAME_LOCK;
    }

    String getIntValuePath(String tenantId, String tablename) {
        return this.rootPath + INT_KEY_NODE_PATH + "/" + tenantId.toLowerCase() + "/" + tablename.toLowerCase() + "/" + NODE_NAME_VALUE;
    }

    String getStatus() {
        StringBuilder ss = new StringBuilder(256);
        ss.append("    rootPath=").append(this.rootPath);
        ss.append("\r\n    sessionTimeout=").append(this.sessionTimeout).append("ms");
        ss.append("\r\n    sessionReconnectCount=").append(this.sessionReconnectCount);
        ss.append("\r\n    groupWorkers=").append(this.groupWorkers);
        ss.append("\r\n    logStatusInterval=").append(this.logStatusInterval).append("ms");
        ss.append("\r\n    clockBackStrategy=").append((Object)this.clockBackStrategy);
        ss.append("\r\n    lockProvider=").append((Object)this.lockProvider);
        return ss.toString();
    }
}

