/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import kd.bos.util.DisCardUtil;

class IDWorkerClockChecker {
    private volatile boolean stopped = false;
    private ClockCheckCallBack checkCB;

    public IDWorkerClockChecker(int workderId, ClockCheckCallBack checkCB) {
        this.checkCB = checkCB;
    }

    public IDWorkerClockChecker start(int workerId, final long updateClockInterval) {
        Thread th = new Thread(){

            @Override
            public void run() {
                while (!IDWorkerClockChecker.this.stopped && !Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(updateClockInterval);
                        IDWorkerClockChecker.this.checkCB.call();
                    }
                    catch (InterruptedException e) {
                        DisCardUtil.discard();
                    }
                }
            }
        };
        th.setName("ID-ClockCheck-Worker-" + workerId);
        th.setDaemon(true);
        th.setPriority(10);
        th.start();
        return this;
    }

    public void stop() {
        this.stopped = true;
    }

    @FunctionalInterface
    static interface ClockCheckCallBack {
        public void call();
    }
}

