/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker;

import com.google.common.base.Preconditions;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public enum AssignerType {
    REDIS_ASSIGNER("redis"),
    DB_ASSIGNER("db");

    private String typeName;

    private AssignerType(String typeName) {
        this.typeName = typeName;
    }

    public static AssignerType from(String typeName) {
        Preconditions.checkArgument((typeName != null ? 1 : 0) != 0);
        for (AssignerType value : AssignerType.values()) {
            if (!value.typeName.equalsIgnoreCase(typeName)) continue;
            return value;
        }
        throw new KDException(BosErrorCode.bosId, new Object[]{String.format("unknown assigner type name=%s", typeName)});
    }

    public String getTypeName() {
        return this.typeName;
    }
}

