/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker.impl;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.worker.AbstractWorkerAssigner;
import kd.bos.id.worker.DBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBStoreWorkerAssigner
extends AbstractWorkerAssigner {
    private static final Logger logger = LoggerFactory.getLogger(DBStoreWorkerAssigner.class);
    private static volatile boolean initiatedTable = false;
    private static ExtensionFactory<DBStore> extensionFactory = ExtensionFactory.getExtensionFacotry(DBStore.class);
    private static DBStore dbStore = DBStoreWorkerAssigner.getExtension();

    private static DBStore getExtension() {
        try {
            return (DBStore)extensionFactory.getExtension(System.getProperty("IDService.assigner.dbstore", "bos"));
        }
        catch (Error | Exception e) {
            logger.error("DBStoreWorkerAssigner init extension implement fail: " + e.getMessage() + ",Execute System.exit(-1) starting to exit the service\uff1a", e);
            e.printStackTrace();
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.exit(-1);
            return null;
        }
    }

    public DBStoreWorkerAssigner(IDServiceAssignerConfig idServiceAssignerConfig) {
        super(idServiceAssignerConfig);
    }

    @Override
    protected String getWorkerIdAssignedTime() {
        DBStoreWorkerAssigner.checkInitiatedTable();
        return dbStore.getWorkerIdAssignedTime(this.getWorkerId());
    }

    @Override
    protected void setWorkerIdAssignTime(String lastCheckTimestamp) {
        DBStoreWorkerAssigner.checkInitiatedTable();
        dbStore.setWorkerIdAssignTime(this.getWorkerId(), lastCheckTimestamp);
    }

    @Override
    public int registerWorkerId() {
        DBStoreWorkerAssigner.checkInitiatedTable();
        return dbStore.insertWorkerIdAndGet(this.idServiceAssignerConfig, this.instanceInfo, 1800000L);
    }

    @Override
    protected boolean ifNeedRetryRegisterAndReportWorker() {
        DBStoreWorkerAssigner.checkInitiatedTable();
        return false;
    }

    @Override
    protected int getThenIncrement(String lockPath, String valuePath, int count) {
        DBStoreWorkerAssigner.checkInitiatedTable();
        return dbStore.getThenIncrement(this.idServiceAssignerConfig, lockPath, valuePath, count);
    }

    private static void checkInitiatedTable() {
        if (!initiatedTable) {
            throw new KDException(BosErrorCode.bosId, new Object[]{"do not init id worker table store"});
        }
    }

    public static void clean(IDServiceAssignerConfig idServiceAssignerConfig, long invalidTimeout) {
        DBStoreWorkerAssigner.checkInitiatedTable();
        dbStore.cleanInvalidWorker(idServiceAssignerConfig, invalidTimeout);
    }

    public String toString() {
        return "ID-DBStoreWorkerAssigner-" + this.getWorkerId();
    }

    static {
        if (!initiatedTable) {
            try {
                initiatedTable = dbStore.initTable();
            }
            catch (Exception e) {
                logger.error("DBStoreWorkerAssigner init table failed: " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

