/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker.impl;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.Resources;
import kd.bos.dlock.DLockUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.IDServiceLog;
import kd.bos.id.worker.AbstractWorkerAssigner;
import kd.bos.id.worker.service.CleanExpireWorkerIdService;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;

public final class RedisWorkerAssigner
extends AbstractWorkerAssigner {
    private static final Random random = new SecureRandom();

    public RedisWorkerAssigner(IDServiceAssignerConfig config) {
        super(config);
    }

    @Override
    public int registerWorkerId() {
        try (JedisClient storeClient = this.getStoreClient();){
            String workerStorePath = this.idServiceAssignerConfig.getLongWorkerListPath();
            if (!storeClient.exists(workerStorePath).booleanValue()) {
                this.waitMilliSeconds(6L * this.idServiceAssignerConfig.getTolerantClockBackTimestamp());
            }
            int w = random.nextInt(this.idServiceAssignerConfig.getMaxWorkerCount());
            AtomicInteger times = new AtomicInteger(0);
            AtomicBoolean hasMaxCount = new AtomicBoolean(false);
            String prefix = this.instanceInfo + '#';
            String info = prefix + System.currentTimeMillis();
            while (storeClient.hsetnx(this.idServiceAssignerConfig.getLongWorkerListPath(), String.valueOf(w), info) != 1L) {
                if (times.incrementAndGet() > this.idServiceAssignerConfig.getMaxWorkerCount()) {
                    if (hasMaxCount.compareAndSet(false, true)) {
                        try {
                            CleanExpireWorkerIdService.CleanRedisWorkerIdThread.clean(this.idServiceAssignerConfig);
                            IDServiceLog.debug("reach id max worker count, clean expire worker id");
                            times.set(0);
                        }
                        catch (Exception e) {
                            DisCardUtil.discard();
                        }
                    } else {
                        throw new KDException(BosErrorCode.bosId, new Object[]{Resources.get((String)"bos-id", (String)"IDServiceImplWorker_6", (String)"WorkerId\u5df2\u7528\u5b8c(%1$s)", (Object[])new Object[]{this.idServiceAssignerConfig.getMaxWorkerCount()})});
                    }
                }
                w = hasMaxCount.get() ? times.get() - 1 : random.nextInt(this.idServiceAssignerConfig.getMaxWorkerCount());
                info = prefix + System.currentTimeMillis();
            }
            int n = w;
            return n;
        }
    }

    private void waitMilliSeconds(long milliSeconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
    }

    @Override
    protected boolean ifNeedRetryRegisterAndReportWorker() {
        if (this.startUpped.get()) {
            try (JedisClient storeClient = this.getStoreClient();){
                String workerIdStorePath = this.idServiceAssignerConfig.getLongWorkerListPath();
                String keepInfo = this.instanceInfo + '#' + System.currentTimeMillis();
                String workerId = String.valueOf(this.getWorkerId());
                if (storeClient.hsetnx(workerIdStorePath, workerId, keepInfo) != 1L) {
                    int firstIndexDelimit;
                    String existInfo = storeClient.hget(workerIdStorePath, workerId);
                    if (!StringUtils.isEmpty((String)existInfo) && (firstIndexDelimit = existInfo.indexOf(35)) != -1) {
                        String currentInstance = Instance.getInstanceId();
                        String instance = existInfo.substring(0, firstIndexDelimit);
                        if (!instance.equals(currentInstance) && DLockUtil.isInstanceAlive((String)instance)) {
                            IDServiceLog.debug(String.format("current instance info{%s} was different to register info {%s}, worker path was {%s}, register again", currentInstance, instance, workerIdStorePath));
                            boolean bl = true;
                            return bl;
                        }
                    }
                    storeClient.hset(workerIdStorePath, workerId, keepInfo);
                }
            }
        }
        return false;
    }

    @Override
    protected String getWorkerIdAssignedTime() {
        try (JedisClient storeClient = this.getStoreClient();){
            String string = storeClient.hget(this.idServiceAssignerConfig.getLongWorkerTimePath(), String.valueOf(this.getWorkerId()));
            return string;
        }
    }

    @Override
    protected void setWorkerIdAssignTime(String lastCheckTimestamp) {
        try (JedisClient storeClient = this.getStoreClient();){
            storeClient.hset(this.idServiceAssignerConfig.getLongWorkerTimePath(), String.valueOf(this.getWorkerId()), lastCheckTimestamp);
        }
    }

    @Override
    protected int getThenIncrement(String lockPath, String valuePath, int count) {
        try (JedisClient storeClient = this.getStoreClient();){
            int intIdMinValue = this.idServiceAssignerConfig.getIntIdMinValue();
            storeClient.setnx(valuePath, String.valueOf(intIdMinValue));
            int value = storeClient.incrBy(valuePath, (long)count).intValue();
            int n = value - count;
            return n;
        }
    }

    public JedisClient getStoreClient() {
        return RedisFactory.getJedisClient((String)this.idServiceAssignerConfig.getServer());
    }

    public String toString() {
        return "ID-RedisWorkerAssigner-" + this.getWorkerId();
    }
}

