/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker.service;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dlock.DLockUtil;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.worker.AssignerType;
import kd.bos.id.worker.impl.DBStoreWorkerAssigner;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanExpireWorkerIdService {
    private static final Logger logger = LoggerFactory.getLogger(CleanExpireWorkerIdService.class);
    private static final CleanExpireWorkerIdService instance = new CleanExpireWorkerIdService();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private CleanRedisWorkerIdThread thread;

    private CleanExpireWorkerIdService() {
    }

    public void start(final IDServiceAssignerConfig idServiceAssignerConfig) {
        if (this.started.compareAndSet(false, true)) {
            Elector elector = ElectFactory.getElector((String)"ID.clean_expire_elect");
            elector.registerListener(new ElectorListener(){

                public void notifyMaster() {
                    logger.info("ID.clean_expire_elect notifyMaster start.");
                    CleanExpireWorkerIdService.this.thread = new CleanRedisWorkerIdThread(idServiceAssignerConfig);
                    CleanExpireWorkerIdService.this.thread.setName("ID-Clean-Expire-Worker");
                    CleanExpireWorkerIdService.this.thread.setDaemon(true);
                    CleanExpireWorkerIdService.this.thread.start();
                    logger.info("ID.clean_expire_elect notifyMaster end.");
                }

                public void notifyLostMaster() {
                    logger.info("ID.clean_expire_elect notifyLostMaster start.");
                    if (CleanExpireWorkerIdService.this.thread != null) {
                        CleanExpireWorkerIdService.this.thread.interrupt();
                    }
                    logger.info("ID.clean_expire_elect notifyLostMaster end.");
                }
            });
            elector.start();
        }
    }

    public static CleanExpireWorkerIdService getInstance() {
        return instance;
    }

    public static final class CleanRedisWorkerIdThread
    extends Thread {
        public static final long invalidTimeout = 1800000L;
        private static final long cleanInterval = 600000L;
        private IDServiceAssignerConfig idServiceAssignerConfig;

        private CleanRedisWorkerIdThread(IDServiceAssignerConfig idServiceAssignerConfig) {
            this.idServiceAssignerConfig = idServiceAssignerConfig;
        }

        @Override
        public void run() {
            block3: {
                AssignerType assignerType;
                block2: {
                    assignerType = AssignerType.from(this.idServiceAssignerConfig.getWorkerIdAssignerType());
                    if (assignerType != AssignerType.REDIS_ASSIGNER) break block2;
                    while (!Thread.interrupted() && this.snoopRound(600000L)) {
                        CleanRedisWorkerIdThread.clean(this.idServiceAssignerConfig);
                    }
                    break block3;
                }
                if (assignerType != AssignerType.DB_ASSIGNER) break block3;
                while (!Thread.interrupted() && this.snoopRound(600000L)) {
                    DBStoreWorkerAssigner.clean(this.idServiceAssignerConfig, 1800000L);
                }
            }
        }

        public static void clean(IDServiceAssignerConfig idServiceAssignerConfig) {
            try (JedisClient jedisClient = RedisFactory.getJedisClient((String)idServiceAssignerConfig.getServer());){
                String workerIdStorePath = idServiceAssignerConfig.getLongWorkerListPath();
                Map existWorkerInfos = jedisClient.hgetAll(workerIdStorePath);
                for (Map.Entry existWorkerInfo : existWorkerInfos.entrySet()) {
                    long ts;
                    String[] split;
                    String workerId = (String)existWorkerInfo.getKey();
                    String value = (String)existWorkerInfo.getValue();
                    if (StringUtils.isEmpty((String)value) || (split = value.split("#")).length != 3) continue;
                    String ip = split[1];
                    if (!InetAddress.getByName(ip).isReachable(3000)) {
                        jedisClient.hdel(workerIdStorePath, new String[]{workerId});
                        continue;
                    }
                    if (DLockUtil.isInstanceAlive((String)split[0]) || (ts = Long.parseLong(split[2]) + 1800000L - System.currentTimeMillis()) >= 0L) continue;
                    jedisClient.hdel(workerIdStorePath, new String[]{workerId});
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }

        private boolean snoopRound(long ts) {
            try {
                Thread.sleep(ts);
            }
            catch (InterruptedException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

