/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lock.curator;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.bundle.Resources;
import kd.bos.dlock.CrossCluster;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lock.DLock;
import kd.bos.lock.DLockHandler;
import kd.bos.lock.DLockListener;
import kd.bos.lock.DLockLog;
import kd.bos.lock.DLockRestarting;
import kd.bos.lock.DLockUtil;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CuratorLocker
implements DLock,
DLockRestarting {
    private static final String TRACER_NAME = "ID";
    private static final String AUDIT_NAME = "id_cost";
    private CuratorFramework client;
    private String connectString;
    private int connectionTimeoutMs;
    private DLockListener dl;
    private AtomicBoolean connectLost = new AtomicBoolean(false);
    private DLockRestarting restartedLocker = null;
    private volatile boolean restarting = false;
    private ReentrantLock restartLock = new ReentrantLock();
    private final String zkRootPath;

    public CuratorLocker(String connectString, int sessionTimeoutMs, DLockListener dl) throws KDException {
        this.zkRootPath = ZKFactory.getZkRootPath((String)connectString) + CrossCluster.getClusterNameForPath() + '/';
        this.connectString = connectString;
        if (sessionTimeoutMs < 2000) {
            sessionTimeoutMs = 2000;
        }
        this.connectionTimeoutMs = sessionTimeoutMs * 2;
        this.dl = dl;
        this.start();
    }

    private void start() throws KDException {
        this.client = ZKFactory.getZKClient((String)this.connectString);
        this.log(Resources.getString((String)"bos-id", (String)"CuratorLocker_1", (Object[])new Object[0]));
    }

    private void log(String msg) {
        DLockLog.debug(msg);
    }

    @Override
    public void close() throws KDException {
    }

    @Override
    public <T> T lock(String path, DLockHandler<T> h) throws KDException {
        return (T)this.retryCall(() -> {
            InterProcessSemaphoreMutex sharedLock = new InterProcessSemaphoreMutex(this.getWorkClient(), this.zkRootPath + (path.startsWith("/") ? this.removeClusterPrefix(path.substring(1)) : this.removeClusterPrefix(path)));
            boolean acquired = false;
            try (TraceSpan ts = Tracer.create((String)TRACER_NAME, (String)"lock");
                 MemSpanTrace mst = MemSpanTrace.create((String)TRACER_NAME, (String)"lock");
                 Auditable audit = Audit.audit((String)AUDIT_NAME, (Object[])new Object[]{path});){
                mst.addTag("path", path);
                ts.addTag("path", path);
                acquired = sharedLock.acquire((long)this.connectionTimeoutMs, TimeUnit.MILLISECONDS);
            }
            if (acquired) {
                try {
                    Object t = h.handle();
                    return t;
                }
                finally {
                    sharedLock.release();
                }
            }
            throw new KDException(BosErrorCode.bosId, new Object[]{this.connectionTimeoutMs + Resources.getString((String)"bos-id", (String)"CuratorLocker_2", (Object[])new Object[0]) + path});
        });
    }

    private String removeClusterPrefix(String path) {
        String clusterName = CrossCluster.getClusterNameForPath();
        return path.startsWith(clusterName) ? (path.substring(clusterName.length()).startsWith("/") ? path.substring(clusterName.length() + 1) : path.substring(clusterName.length())) : path;
    }

    @Override
    public <T> void lockAsync(final String path, final DLockHandler<T> h) throws KDException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    CuratorLocker.this.lock(path, h);
                }
                catch (Exception e) {
                    throw DLockUtil.asRuntimeException(e);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public String get(String path) throws KDException {
        return this.retryCall(() -> {
            try {
                byte[] bs = (byte[])this.getWorkClient().getData().forPath(path);
                return bs == null ? null : new String(bs, StandardCharsets.UTF_8);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
        });
    }

    @Override
    public List<String> getChildren(String path) throws KDException {
        return this.retryCall(() -> {
            try {
                return (List)this.getWorkClient().getChildren().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                return new ArrayList();
            }
        });
    }

    @Override
    public void set(String path, String value) throws KDException {
        this.retryCall(() -> {
            byte[] bs = value == null ? DLockUtil.empty_data : value.getBytes(StandardCharsets.UTF_8);
            try {
                this.getWorkClient().create().creatingParentContainersIfNeeded().forPath(path, bs);
            }
            catch (KeeperException.NodeExistsException e) {
                this.getWorkClient().setData().forPath(path, bs);
            }
            return null;
        });
    }

    @Override
    public void setEphemeral(String path, String value) throws KDException {
        this.retryCall(() -> {
            byte[] bs = value == null ? DLockUtil.empty_data : value.getBytes(StandardCharsets.UTF_8);
            try {
                ((ACLBackgroundPathAndBytesable)this.getWorkClient().create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, bs);
            }
            catch (KeeperException.NodeExistsException e) {
                this.getWorkClient().setData().forPath(path, bs);
            }
            return null;
        });
    }

    @Override
    public void del(String path) throws KDException {
        this.retryCall(() -> (Void)this.getWorkClient().delete().forPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T retryCall(Callable<T> opt) throws KDException {
        try {
            boolean connLost = this.connectLost.get();
            if (!connLost) {
                return opt.call();
            }
            if (this.restartedLocker != null) return opt.call();
            if (this.restarting) {
                return opt.call();
            }
            if (this.dl == null) throw new IllegalStateException(Resources.getString((String)"bos-id", (String)"CuratorLocker_3", (Object[])new Object[0]));
            try {
                this.restartLock.lock();
                if (this.restartedLocker == null) {
                    this.dl.retryOnDisconnected(restartedLocker -> {
                        this.restartedLocker = (DLockRestarting)((Object)restartedLocker);
                        return null;
                    });
                }
                T t = opt.call();
                return t;
            }
            finally {
                this.restartLock.unlock();
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bosId, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void restarting(boolean restarting) {
        this.restarting = restarting;
    }

    @Override
    public boolean isRestarting() {
        return this.restarting;
    }

    public CuratorFramework getWorkClient() {
        if (this.restartedLocker != null) {
            return (CuratorFramework)this.restartedLocker.getWorkClient();
        }
        return this.client;
    }
}

