/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import java.net.InetAddress;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.instance.Instance;
import kd.bos.lang.SystemEnv;
import kd.bos.logging.logback.report.LogObject;
import kd.bos.thread.ThreadTruck;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerFormat {
    private static Logger logger = LoggerFactory.getLogger(LoggerFormat.class);
    private static final String TRACE_PREFIX = CoreConstants.LINE_SEPARATOR + "    ";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)UTC);
    private long lastTimestamp = -1L;
    private String timestampStrCache = null;
    private static String appName;
    private static String hostName;
    private static String localIp;

    public LogObject convert(ILoggingEvent event) {
        Map taginfo;
        StackTraceElement[] cda;
        LogObject log = new LogObject();
        log.setClusterName(Instance.getClusterName());
        log.setAppName(appName);
        log.setInstanceId(Instance.getInstanceId());
        log.setIp(localIp);
        log.setTime(this.getTime(event));
        log.setLevel(event.getLevel().toString());
        log.setMessage(event.getFormattedMessage());
        if (event.getThrowableProxy() != null) {
            log.setExceptionMessage(event.getThrowableProxy().getMessage());
            log.setExceptionClass(event.getThrowableProxy().getClassName());
            log.setStacktrace(this.renderStacktrace(event));
        }
        if (!this.fillMore(cda = event.getCallerData(), log)) {
            log.setClassName(event.getLoggerName());
            log.setMethodName(this.getMethodName(cda));
            log.setLine(this.getLineNumber(cda));
        }
        if ((taginfo = (Map)ThreadTruck.get((Object)"rcinfo")) != null) {
            log.getLogtags().putAll(taginfo);
        }
        return log;
    }

    public void start() {
        appName = System.getProperty("appName");
        appName = appName == null ? "unknown" : appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTime(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        LoggerFormat loggerFormat = this;
        synchronized (loggerFormat) {
            if (timestamp == this.lastTimestamp) {
                return this.timestampStrCache;
            }
            this.lastTimestamp = timestamp;
            this.timestampStrCache = ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLS.format(timestamp);
            return this.timestampStrCache;
        }
    }

    private boolean fillMore(StackTraceElement[] cda, LogObject log) {
        if (cda != null) {
            for (StackTraceElement trace : cda) {
                if (trace.getClassName().startsWith("kd.bos.logging")) continue;
                this.fill(trace, log);
                return true;
            }
        }
        return false;
    }

    private void fill(StackTraceElement trace, LogObject log) {
        log.setClassName(trace.getClassName());
        log.setLine(trace.getLineNumber());
        log.setMethodName(trace.getMethodName());
    }

    private int getLineNumber(StackTraceElement[] cda) {
        if (cda != null && cda.length > 0) {
            return cda[0].getLineNumber();
        }
        return -1;
    }

    private String getMethodName(StackTraceElement[] cda) {
        if (cda != null && cda.length > 0) {
            return cda[0].getMethodName();
        }
        return "?";
    }

    private String renderStacktrace(ILoggingEvent event) {
        StringBuilder sbuf = new StringBuilder();
        for (IThrowableProxy tp = event.getThrowableProxy(); tp != null; tp = tp.getCause()) {
            this.renderStacktrace(sbuf, tp);
        }
        return sbuf.toString();
    }

    private void renderStacktrace(StringBuilder sbuf, IThrowableProxy tp) {
        this.printFirstLine(sbuf, tp);
        int commonFrames = tp.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(step.toString());
        }
        if (commonFrames > 0) {
            sbuf.append(TRACE_PREFIX);
            sbuf.append("\t... ").append(commonFrames).append(" common frames omitted");
        }
    }

    private void printFirstLine(StringBuilder sb, IThrowableProxy tp) {
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            sb.append(CoreConstants.LINE_SEPARATOR).append("Caused by: ");
        }
        sb.append(tp.getClassName()).append(": ").append(tp.getMessage());
    }

    static {
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
            hostName = ia.getHostName();
            localIp = ia.getHostAddress();
            appName = SystemEnv.getProperty((String)"appName");
        }
        catch (Exception e) {
            logger.error("init Exception:", (Throwable)e);
        }
    }
}

