/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cage.container.AbstractCageContainer;
import kd.bos.cage.container.ContainerType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TenantCageContainer
extends AbstractCageContainer {
    private static Log log = LogFactory.getLog(AbstractCageContainer.class);
    private List<AbstractCageContainer> resContainerSet = new ArrayList<AbstractCageContainer>();
    private ConcurrentHashMap<Integer, Integer> pidFilterMap = new ConcurrentHashMap();

    public TenantCageContainer(String tenantId) {
        this.setContainerType(ContainerType.tenant.toString());
        this.setTenantId(tenantId);
        this.registerSpecificContainer(tenantId);
    }

    @Override
    public void controlThread(int pid) {
        if (this.pidFilterMap.containsKey(pid)) {
            return;
        }
        this.pidFilterMap.put(pid, 0);
        String tenantId = this.getTenantId();
        if (tenantId == null || tenantId.trim().isEmpty()) {
            log.error("to control pid container's tenant id is null!");
        }
        for (AbstractCageContainer container : this.resContainerSet) {
            container.setTenantId(tenantId);
            container.controlThread(pid);
        }
    }

    @Override
    public void unControlThread(int pid) {
        this.pidFilterMap.remove(pid);
        for (AbstractCageContainer container : this.resContainerSet) {
            container.unControlThread(pid);
        }
    }

    @Override
    public void build() {
        for (AbstractCageContainer container : this.resContainerSet) {
            container.setRelativePath(this.getRelativePath());
            container.build();
        }
    }

    @Override
    public Map<ContainerType, Object> meter() {
        HashMap<ContainerType, Object> map = new HashMap<ContainerType, Object>();
        for (AbstractCageContainer container : this.resContainerSet) {
            Map<ContainerType, Object> usage = container.meter();
            map.putAll(usage);
        }
        return map;
    }

    @Override
    public void updateQuota(String quota) {
        for (AbstractCageContainer container : this.resContainerSet) {
            container.updateQuota(quota);
        }
    }

    private void registerSpecificContainer(String tenantId) {
        ServiceLoader<AbstractCageContainer> containers = ServiceLoader.load(AbstractCageContainer.class);
        for (AbstractCageContainer container : containers) {
            container.setTenantId(tenantId);
            this.resContainerSet.add(container);
        }
    }
}

