/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.container;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.cage.commons.CageConstants;
import kd.bos.cage.container.AbstractCageContainer;
import kd.bos.cage.container.ContainerType;
import kd.bos.cage.container.ICageContainerService;
import kd.bos.cage.container.IRealQuotaGenerator;
import kd.bos.cage.container.impl.CageContainerService;
import kd.bos.cage.container.impl.CpuRealQuotaGenerator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class TenantCpuCageContainer
extends AbstractCageContainer {
    private static final Log log = LogFactory.getLog(TenantCpuCageContainer.class);
    public static final String CPU_CFS_QUOTA_US = "cpu.cfs_quota_us";
    public static final String CPU_CPUACCT_USAGE = "cpuacct.usage";
    private long meterTime;
    private long usage;
    private int coreSize = Runtime.getRuntime().availableProcessors();
    private IRealQuotaGenerator generator;
    private ICageContainerService containerService;

    public TenantCpuCageContainer() {
        this.setContainerType(ContainerType.cpu.toString());
        ServiceLoader<IRealQuotaGenerator> generators = ServiceLoader.load(IRealQuotaGenerator.class);
        generators.forEach(generatorSPI -> {
            if (generatorSPI.getClass().getTypeName().contains(CpuRealQuotaGenerator.class.getSimpleName())) {
                this.generator = generatorSPI;
            }
        });
        this.containerService = CageContainerService.getInstance();
    }

    @Override
    public void controlThread(int pid) {
        this.containerService.addPidToContainer(ContainerType.cpu, pid, this.getRelativePath());
    }

    @Override
    public void unControlThread(int pid) {
        this.containerService.delPidFromContainer(ContainerType.cpu, pid);
    }

    @Override
    public void build() {
        this.containerService.createContainer(ContainerType.cpu, this.getRelativePath());
    }

    @Override
    public Map<ContainerType, Object> meter() {
        HashMap<ContainerType, Object> result = new HashMap<ContainerType, Object>(1);
        long currentTime = System.nanoTime();
        long usageCurrent = 0L;
        StringBuilder usagePath = new StringBuilder();
        usagePath.append(CageConstants.CAGE_ROOT_PATH).append(ContainerType.cpu.toString()).append(this.getRelativePath()).append(File.separator).append(CPU_CPUACCT_USAGE);
        String usageStr = "0";
        try {
            List<String> list = Files.readAllLines(Paths.get(usagePath.toString(), new String[0]));
            if (!list.isEmpty()) {
                usageStr = list.get(0);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        usageCurrent = Long.parseLong(usageStr);
        double percent = this.computePercent(currentTime, usageCurrent);
        this.meterTime = currentTime;
        this.usage = usageCurrent;
        if (percent < 0.1) {
            percent = 0.0;
        }
        result.put(ContainerType.cpu, percent);
        return result;
    }

    @Override
    public void updateQuota(String quota) {
        if (StringUtils.isEmpty((String)quota) || this.generator == null) {
            return;
        }
        String cpuRealQuota = this.generator.generate(quota);
        this.containerService.updateContainerQuota(ContainerType.cpu, this.getRelativePath(), CPU_CFS_QUOTA_US, cpuRealQuota);
    }

    private double computePercent(long currentTime, long currentUsage) {
        if (this.meterTime == 0L) {
            this.meterTime = currentTime;
            this.usage = currentUsage;
            return 0.0;
        }
        long used = currentUsage - this.usage;
        long time = currentTime - this.meterTime;
        long totalTime = time * (long)this.coreSize;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)used / (float)totalTime * 100.0f);
        return Double.parseDouble(result);
    }
}

