/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.controller.impl;

import kd.bos.cage.container.TenantCageContainer;
import kd.bos.cage.controller.IThreadBinder;
import kd.bos.cage.jni.NativeExecutor;
import kd.bos.cage.tenant.impl.CageTenantService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ThreadBinder
implements IThreadBinder {
    private static final Log log = LogFactory.getLog(ThreadBinder.class);
    private static final ThreadLocal<String> TENANT_ID_STORE = ThreadLocal.withInitial(() -> "");

    public static IThreadBinder getInstance() {
        return SingletonHolder.instance;
    }

    private ThreadBinder() {
    }

    @Override
    public void bindThreadToContainer() {
        RequestContext rc = RequestContext.get();
        if (rc != null && StringUtils.isNotEmpty((String)rc.getTenantId())) {
            TENANT_ID_STORE.set(rc.getTenantId());
            this.process(Action.joinContainer);
        }
    }

    @Override
    public void unBindThreadFromContainer() {
        this.process(Action.exitContainer);
        TENANT_ID_STORE.remove();
    }

    private void process(Action action) {
        try {
            String tenantId = TENANT_ID_STORE.get();
            if (StringUtils.isNotEmpty((String)tenantId)) {
                int taskPID = NativeExecutor.getInstance().getCurrentThreadPid();
                TenantCageContainer container = CageTenantService.getInstance().getContainerByTenantId(tenantId);
                if (container != null) {
                    if (Action.joinContainer == action) {
                        container.controlThread(taskPID);
                    } else if (Action.exitContainer == action) {
                        container.unControlThread(taskPID);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static enum Action {
        joinContainer,
        exitContainer;

    }

    private static class SingletonHolder {
        private static final IThreadBinder instance = new ThreadBinder();

        private SingletonHolder() {
        }
    }
}

