/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.jni;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kd.bos.cage.commons.CageException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SoLoader {
    private static final Log log = LogFactory.getLog(SoLoader.class);
    private static final String CAGE_NATIVE_LIBRARY_NAME = "libKDCage";
    private static final String LIB_EXT_NAME = "so";

    public void loadSO() throws CageException {
        File soFileCopy = this.copySoFromJar();
        try {
            System.load(soFileCopy.getAbsolutePath());
            log.info("native lib libKDCage.so load success.");
        }
        catch (SecurityException | UnsatisfiedLinkError | CageException e) {
            log.error("Cage  loadSO exec System.load() file=[{}],error->{}", (Object)soFileCopy.getAbsolutePath(), (Object)e.getMessage());
            throw new CageException("Load libKDCage.so file UnsatisfiedLinkError error\uff01", e);
        }
        catch (Exception exception) {
            log.error("Cage  loadSO exec System.load() file=[{}],error->{}", (Object)soFileCopy.getAbsolutePath(), (Object)exception.getMessage());
            throw new CageException("Load libKDCage.so  security error", exception);
        }
    }

    private File copySoFromJar() throws CageException {
        String cageJarPath = this.getJarPath();
        StringBuilder destSoPath = new StringBuilder(cageJarPath).append(File.separator).append(CAGE_NATIVE_LIBRARY_NAME).append(".").append(LIB_EXT_NAME);
        File destSoFile = new File(destSoPath.toString());
        if (!destSoFile.exists()) {
            try {
                Files.createFile(Paths.get(destSoFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (Exception ex) {
                log.error("Cage create to dest so file path=[{}],error->{}", (Object)destSoFile.getAbsolutePath(), (Object)ex.getMessage());
                throw new CageException("bos-cage:Create  libKDCage.so copy file error in " + destSoFile.getAbsolutePath() + " dir.", ex);
            }
        }
        StringBuilder srcSoRelativePath = new StringBuilder(File.separator).append(LIB_EXT_NAME).append(File.separator).append(CAGE_NATIVE_LIBRARY_NAME).append(".").append(LIB_EXT_NAME);
        try (InputStream link = this.getClass().getResourceAsStream(srcSoRelativePath.toString());){
            Files.copy(link, destSoFile.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            log.error("Cage copy so file dest to file=[{}], error->{}.", (Object)srcSoRelativePath.toString(), (Object)ioe.getMessage());
            throw new CageException("bos-cage:copy libKDCage.so file error!", ioe);
        }
        return destSoFile;
    }

    private String getJarPath() {
        String toCopyDirPath = "";
        toCopyDirPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        toCopyDirPath = toCopyDirPath.substring(0, toCopyDirPath.lastIndexOf(File.separator));
        return toCopyDirPath;
    }
}

