/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import kd.bos.cage.commons.CageException;
import kd.bos.government.Constant;
import kd.bos.util.StringUtils;

public abstract class AbstractMetricsQueryCondition {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private int pageSize;
    private String[] includeFieldsResult = new String[0];
    private String[] excludeFieldsResult = new String[0];
    private String indexPre;
    private List<String> filterApps;
    private List<String> filterHosts;
    private String metricType;
    private String esFieldNameMetric;
    private String tidFlag;
    private Date start;
    private Date end;

    public List<String> getFilterApps() {
        return this.filterApps;
    }

    public void setFilterApps(List<String> filterApps) {
        this.filterApps = filterApps;
    }

    public List<String> getFilterHosts() {
        return this.filterHosts;
    }

    public void setFilterHosts(List<String> filterHosts) {
        this.filterHosts = filterHosts;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public void setEsFieldNameMetric(String esFieldNameMetric) {
        this.esFieldNameMetric = esFieldNameMetric;
    }

    public void setTidFlag(String tidFlag) {
        this.tidFlag = tidFlag;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getIndexPre() {
        return this.indexPre;
    }

    public void setIndexPre(String indexPre) {
        this.indexPre = indexPre;
    }

    public String[] getIncludeFieldsResult() {
        return this.includeFieldsResult;
    }

    public void setIncludeFieldsResult(String[] includeFieldsResult) {
        this.includeFieldsResult = includeFieldsResult;
    }

    public String[] getExcludeFieldsResult() {
        return this.excludeFieldsResult;
    }

    public void setExcludeFieldsResult(String[] excludeFieldsResult) {
        this.excludeFieldsResult = excludeFieldsResult;
    }

    public String getEsFieldNameMetric() {
        return this.esFieldNameMetric;
    }

    public String getTidFlag() {
        return this.tidFlag;
    }

    public String dateToString(Date date) {
        if (date == null) {
            throw new CageException("Cage: date is null!");
        }
        return this.dateFormat.format(date);
    }

    public Date stringToDate(String date) throws ParseException {
        if (StringUtils.isEmpty((String)date)) {
            throw new CageException("Cage: date is empty!");
        }
        try {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new CageException("Cage: parser date error,", e);
        }
    }

    public String[] getIndices() {
        ImmutableSet betweenTime = new TreeSet();
        try {
            SimpleDateFormat indexDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar sCalendar = Calendar.getInstance();
            sCalendar.setTime(this.start);
            int year = sCalendar.get(1);
            int month = sCalendar.get(2);
            int day = sCalendar.get(5);
            sCalendar.set(year, month, day, 0, 0, 0);
            Calendar eCalendar = Calendar.getInstance();
            eCalendar.setTime(this.end);
            year = eCalendar.get(1);
            month = eCalendar.get(2);
            day = eCalendar.get(5);
            eCalendar.set(year, month, day, 0, 0, 0);
            while (sCalendar.before(eCalendar)) {
                betweenTime.add(this.indexPre + indexDateFormat.format(sCalendar.getTime()));
                sCalendar.add(6, 1);
            }
            betweenTime.add(this.indexPre + indexDateFormat.format(eCalendar.getTime()));
            if (betweenTime.size() > Constant.SEARCH_RANGE_MAX) {
                betweenTime = ImmutableSet.copyOf((Iterable)Iterables.limit(betweenTime, (int)Constant.SEARCH_RANGE_MAX));
            }
        }
        catch (Exception e) {
            return betweenTime.toArray(new String[0]);
        }
        return betweenTime.toArray(new String[0]);
    }
}

