/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.metrics.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cage.commons.CageException;
import kd.bos.cage.commons.QueryDataLargeException;
import kd.bos.cage.metrics.AbstractMetricsQueryCondition;
import kd.bos.cage.metrics.CageMetric;
import kd.bos.cage.metrics.FatMetric;
import kd.bos.cage.metrics.ICageMetricDao;
import kd.bos.cage.metrics.impl.CageEsClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class CageMetricDaoES
implements ICageMetricDao {
    private static final Log log = LogFactory.getLog(CageMetricDaoES.class);
    private static final String METRIC_TYPE_QUERY = "metrics_type";
    private static final String TIMESTAMP = "timestamp";
    private static final int METRICS_QUERY_DATA_MAX_LINES = 10000;
    private static final String METRIC_ES_FIELD_NAME = "kd.metrics.cage.usage";
    private static final String METRIC_CAGE_ATTR = "cageMetricsStr";
    private static final String METRIC_APP_NAME = "appName";
    private static final String METRIC_HOST_IP = "ip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FatMetric> queryData(AbstractMetricsQueryCondition cageQueryCondition) {
        if (cageQueryCondition.getStart() == null) {
            throw new CageException("cage:query metrics start time is null.");
        }
        if (cageQueryCondition.getEnd() == null) {
            cageQueryCondition.setEnd(new Date());
        }
        CageEsClient esClient = new CageEsClient();
        ArrayList<FatMetric> cageMetrics = new ArrayList<FatMetric>(100);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(cageQueryCondition.getIndices());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(cageQueryCondition.getPageSize());
        sourceBuilder.trackTotalHits(true);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (!cageQueryCondition.getFilterApps().isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)METRIC_APP_NAME, cageQueryCondition.getFilterApps()));
        }
        if (!cageQueryCondition.getFilterHosts().isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)METRIC_HOST_IP, cageQueryCondition.getFilterHosts()));
        }
        boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)cageQueryCondition.getEsFieldNameMetric()));
        boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)cageQueryCondition.getEsFieldNameMetric(), (Object)cageQueryCondition.getTidFlag()));
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)METRIC_TYPE_QUERY, (String)cageQueryCondition.getMetricType()));
        boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)cageQueryCondition.getStart().getTime()).lte((Object)cageQueryCondition.getEnd().getTime()));
        sourceBuilder.fetchSource(cageQueryCondition.getIncludeFieldsResult(), cageQueryCondition.getExcludeFieldsResult());
        sourceBuilder.sort(TIMESTAMP, SortOrder.ASC);
        searchRequest.source(sourceBuilder).indices(cageQueryCondition.getIndices()).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        sourceBuilder.postFilter((QueryBuilder)boolQuery);
        try {
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.getHits().getTotalHits() > 10000L) {
                throw new QueryDataLargeException();
            }
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            while (searchHits.length > 0) {
                cageMetrics.addAll(this.exchange(searchHits));
                SearchHit last = searchHits[searchHits.length - 1];
                sourceBuilder.searchAfter(last.getSortValues());
                searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
                searchHits = searchResponse.getHits().getHits();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (e instanceof QueryDataLargeException) {
                throw new QueryDataLargeException(e.getMessage(), e);
            }
        }
        finally {
            esClient.close();
        }
        return cageMetrics;
    }

    private List<FatMetric> exchange(SearchHit[] searchHits) {
        ArrayList<FatMetric> fatMetricList = new ArrayList<FatMetric>();
        for (SearchHit hit : searchHits) {
            String hitString = hit.getSourceAsString().replace(METRIC_ES_FIELD_NAME, METRIC_CAGE_ATTR);
            try {
                FatMetric fatMetric = (FatMetric)JSONObject.parseObject((String)hitString, FatMetric.class);
                List cageMetrics = JSONArray.parseArray((String)fatMetric.getCageMetricsStr(), CageMetric.class);
                fatMetric.setCageMetricsStr("");
                fatMetric.setCageMetricsList(cageMetrics);
                fatMetricList.add(fatMetric);
            }
            catch (Exception e) {
                log.error("cage  hit to fat metrics error={} ", (Object)e.getMessage());
            }
        }
        return fatMetricList;
    }
}

