/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cage.tenant.impl;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cage.container.ContainerType;
import kd.bos.cage.container.TenantCageContainer;
import kd.bos.cage.funswitch.CageSwitch;
import kd.bos.cage.metrics.CageMetric;
import kd.bos.cage.metrics.MetricClassify;
import kd.bos.cage.metrics.MetricKey;
import kd.bos.cage.tenant.CageTenant;
import kd.bos.cage.tenant.CageTenantsConverterFactory;
import kd.bos.cage.tenant.ICageTenantService;
import kd.bos.cage.tenant.ICageTenantsConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CageTenantService
implements ICageTenantService {
    private static final Log log = LogFactory.getLog(CageTenantService.class);
    public static final String CONFIG_QUOTA_DEFAULT_TENANT_ID = "default";
    public static final String CPU_QUOTA_DEFAULT_TENANT = "60";
    private final ConcurrentHashMap<String, CageTenant> TENANT_MAPS = new ConcurrentHashMap(100);
    private final Map<String, String> CURRENT_QUOTA = new HashMap<String, String>(100);
    private ICageTenantsConverter tenantsConvertor = CageTenantsConverterFactory.getCovertor();

    private CageTenantService() {
        this.initTenants();
    }

    public static ICageTenantService getInstance() {
        return SingletonHolder.instance;
    }

    private void initTenants() {
        this.CURRENT_QUOTA.put(CONFIG_QUOTA_DEFAULT_TENANT_ID, CPU_QUOTA_DEFAULT_TENANT);
        if (this.TENANT_MAPS.size() == 0) {
            this.TENANT_MAPS.putAll(this.tenantsConvertor.generate());
        }
    }

    @Override
    public CageTenant getTenantById(String tenantId) {
        if (this.TENANT_MAPS.containsKey(tenantId)) {
            return this.TENANT_MAPS.get(tenantId);
        }
        return null;
    }

    @Override
    public List<CageTenant> listAllTenants() {
        ArrayList<CageTenant> tenantList = new ArrayList<CageTenant>(100);
        for (Map.Entry<String, CageTenant> entry : this.TENANT_MAPS.entrySet()) {
            tenantList.add(entry.getValue());
        }
        return tenantList;
    }

    @Override
    public List<String> listAllTenantID() {
        ArrayList<String> tenantIdList = new ArrayList<String>(100);
        for (Map.Entry<String, CageTenant> entry : this.TENANT_MAPS.entrySet()) {
            tenantIdList.add(entry.getKey());
        }
        return tenantIdList;
    }

    @Override
    public TenantCageContainer getContainerByTenantId(String tenantId) {
        CageTenant tenant = this.TENANT_MAPS.get(tenantId);
        if (tenant != null) {
            return tenant.getTenantContainer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTenantsQuota(Map<String, String> quotaMap) {
        if (quotaMap.isEmpty()) {
            return;
        }
        try {
            if (CageSwitch.isOn()) {
                String newDefaultQuota = quotaMap.get(CONFIG_QUOTA_DEFAULT_TENANT_ID);
                for (Map.Entry<String, CageTenant> entry : this.TENANT_MAPS.entrySet()) {
                    String tenantId = entry.getKey();
                    if (tenantId.equals(CONFIG_QUOTA_DEFAULT_TENANT_ID)) continue;
                    String quota = "";
                    quota = !quotaMap.containsKey(tenantId) ? newDefaultQuota : quotaMap.get(tenantId);
                    TenantCageContainer cageContainer = this.getContainerByTenantId(tenantId);
                    if (cageContainer == null) continue;
                    cageContainer.updateQuota(quota);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            this.CURRENT_QUOTA.clear();
            this.CURRENT_QUOTA.putAll(quotaMap);
        }
    }

    @Override
    public String getTenantQuota(String tenantId) {
        if (this.CURRENT_QUOTA.containsKey(tenantId)) {
            return this.CURRENT_QUOTA.get(tenantId);
        }
        return this.CURRENT_QUOTA.get(CONFIG_QUOTA_DEFAULT_TENANT_ID);
    }

    @Override
    public JSONArray meterTenantsMetrics() {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, CageTenant> entry : this.TENANT_MAPS.entrySet()) {
            CageTenant tenant = entry.getValue();
            if (tenant.getTenantContainer() == null) continue;
            CageMetric metric = new CageMetric();
            metric.setCageTid(tenant.getTenantId());
            TenantCageContainer container = tenant.getTenantContainer();
            Map<ContainerType, Object> containerMetric = container.meter();
            for (Map.Entry<ContainerType, Object> metricMetered : containerMetric.entrySet()) {
                String type = metricMetered.getKey().toString();
                String usage = metricMetered.getValue().toString();
                if (type.equals(ContainerType.cpu.toString())) {
                    metric.addMetric(MetricClassify.cpu.toString(), MetricKey.usage.toString(), usage);
                    continue;
                }
                if (!type.equals(ContainerType.mem.toString())) continue;
                metric.addMetric(MetricClassify.mem.toString(), MetricKey.bytes.toString(), usage);
            }
            jsonArray.add((Object)metric);
        }
        return jsonArray;
    }

    private static class SingletonHolder {
        private static final ICageTenantService instance = new CageTenantService();

        private SingletonHolder() {
        }
    }
}

