/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.db;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;

public class ConditionSqlBuilder {
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> params = new ArrayList<Object>();
    private final QFilter root;
    private final AtomicBoolean hasInit = new AtomicBoolean(false);

    public ConditionSqlBuilder(QFilter[] where) {
        this.root = where[0];
        QFilter qFilter = where[0];
        if (where.length > 1) {
            for (int i = 1; i < where.length; ++i) {
                qFilter = qFilter.and(where[i]);
            }
        }
    }

    public void init() {
        AtomicBoolean first = new AtomicBoolean(true);
        if (this.hasInit.compareAndSet(false, true)) {
            this.root.trans(qFilter -> {
                if (!first.get()) {
                    this.sql.append(" AND ");
                }
                this.sql.append(this.genSql((QFilter)qFilter));
                if (qFilter.getCP().equalsIgnoreCase("in") || qFilter.getCP().equalsIgnoreCase("not in")) {
                    QParameter inQP = QFilterUtil.getInQParameter((Object)qFilter.getValue(), (boolean)false);
                    if (inQP != null) {
                        this.params.add(inQP.getParameters());
                    }
                } else {
                    this.params.add(qFilter.getValue());
                }
                first.set(false);
                return qFilter;
            });
        }
    }

    private String genSql(QFilter qFilter) {
        if (qFilter.isExpressValue()) {
            throw LogORMExceptionFactory.createWithContext("Not supported qfilter express value:%s .", qFilter.toString());
        }
        switch (qFilter.getCP().toLowerCase()) {
            case "=": 
            case ">": 
            case "<": 
            case ">=": 
            case "<=": 
            case "!=": 
            case "<>": 
            case "like": 
            case "not like": {
                return qFilter.getProperty() + ' ' + qFilter.getCP() + " ?";
            }
            case "is null": {
                return qFilter.getProperty() + "is null";
            }
            case "is not null": {
                return qFilter.getProperty() + "is not null";
            }
            case "in": 
            case "not in": {
                QParameter inQP = QFilterUtil.getInQParameter((Object)qFilter.getValue(), (boolean)false);
                if (inQP == null) {
                    return "in".equalsIgnoreCase(qFilter.getCP()) ? "1 != 1" : "1 = 1";
                }
                if (inQP.getParameters().length == 1) {
                    return qFilter.getProperty() + ' ' + (qFilter.getCP().equalsIgnoreCase("in") ? "=" : "!=") + " ?";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(qFilter.getProperty()).append(' ').append(qFilter.getCP()).append("(");
                ArrayList<String> p = new ArrayList<String>(inQP.getParameters().length);
                for (int i = 0; i < inQP.getParameters().length; ++i) {
                    p.add("?");
                }
                sb.append(String.join((CharSequence)",", p));
                return sb.toString();
            }
        }
        throw LogORMExceptionFactory.createWithContext("Unsupported qcp: %s .", qFilter.getCP());
    }

    public String getSql() {
        this.init();
        return this.sql.toString();
    }

    public List<Object> getParams() {
        this.init();
        return this.params;
    }
}

