/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.CompletionResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.MappingPropertiesObject;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class AddNotExistFieldAction
extends ESAction<CompletionResponse> {
    private final String indexName;
    private final MappingPropertiesObject propertiesObject;

    public AddNotExistFieldAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String indexName, MappingPropertiesObject propertiesObject) {
        super(context, ds, tenantId, accountId);
        this.indexName = indexName;
        this.propertiesObject = propertiesObject;
    }

    @Override
    protected HttpRequest build() {
        String idxName = this.getIndexAllName(this.indexName, new Date());
        String uri = "/%s/_mapping";
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        if (ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6) {
            uri = uri + "?include_type_name=false";
        }
        String endpoint = String.format(uri, idxName);
        HttpRequest httpRequest = this.createRequest(endpoint, HttpRequest.ContentType.JSON, HttpRequest.RequestType.PUT);
        httpRequest.setData(this.object2Json(this.propertiesObject));
        return httpRequest;
    }

    @Override
    protected CompletionResponse parse(String result) throws JsonProcessingException {
        return new CompletionResponse(){};
    }
}

