/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.government.util.ElasticSearchUtil;
import kd.bos.logorm.client.CompletionResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.MappingTypesObject;
import kd.bos.logorm.codec.DataType;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class CreateMappingAction
extends ESAction<CompletionResponse> {
    private final String entityName;
    private final Date date;

    public CreateMappingAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String entityName, Date date) {
        super(context, ds, tenantId, accountId);
        this.entityName = entityName;
        this.date = date;
    }

    @Override
    protected HttpRequest build() {
        DataEntityMetaProvider dataEntityMetaProvider = this.context.getDataEntityMetaProvider();
        EntityMetadataContext metadataContext = dataEntityMetaProvider.getEntityMetadata(this.entityName);
        int[] sqlTypes = metadataContext.getSqlTypes();
        EntityProperty[] entityProperties = metadataContext.getProperties();
        ArrayList<Integer> types = new ArrayList<Integer>(sqlTypes.length);
        ArrayList<String> names = new ArrayList<String>(sqlTypes.length);
        for (int i = 0; i < entityProperties.length; ++i) {
            EntityProperty property = entityProperties[i];
            if (!property.hasColumnName()) continue;
            names.add(property.getColumnName());
            types.add(sqlTypes[i]);
        }
        DataType[] dataTypes = new DataType[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            dataTypes[i] = DataType.getByJdbcType((Integer)types.get(i));
        }
        String indexSliceName = this.getIndexSliceName(metadataContext.getTableName(), this.date);
        ESConfig.ESCluster esCluster = this.ds.getEsCluster();
        ESConfig.URL url = esCluster.getUrls().get(0);
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig(url.getHost(), url.getPort(), esCluster.getUsername(), esCluster.getNp1(), url.getSchema(), null, null);
        if (ElasticSearchUtil.getVersion((ElasticsearchConfig)elasticsearchConfig) <= 6) {
            indexSliceName = indexSliceName + "?include_type_name=false";
        }
        HttpRequest request = this.createRequest(indexSliceName, HttpRequest.ContentType.JSON, HttpRequest.RequestType.PUT);
        MappingTypesObject data = new MappingTypesObject(names.toArray(new String[0]), dataTypes);
        request.setData(this.object2Json(data));
        return request;
    }

    @Override
    protected CompletionResponse parse(String result) throws JsonProcessingException {
        return new CompletionResponse(){};
    }
}

