/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.logorm.client.es.IndexSliceStrategy;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.util.Pair;

public class DayIndexSliceStrategyImpl
implements IndexSliceStrategy {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    static final IndexSliceStrategy INSTANCE = new DayIndexSliceStrategyImpl();

    @Override
    public String getIndexSliceName(String schema, String table, Date date) {
        LocalDate now = date.toInstant().atZone(LogORMConfig.getTimeZoneId()).toLocalDate();
        return String.format("%s-%s-%s", schema, table, now.format(DATE_FORMATTER));
    }

    @Override
    public String getIndexAllName(String schema, String table, Date date) {
        return String.format("%s-%s-*", schema, table);
    }

    @Override
    public String getIndexAllName(String schema, String table, Date date, DateInterval interval) {
        if (interval == null) {
            return this.getIndexAllName(schema, table, date);
        }
        Pair<LocalDate, LocalDate> range = interval.getDateRange();
        if (range == null) {
            return this.getIndexAllName(schema, table, date);
        }
        LocalDate start = (LocalDate)range.getKey();
        LocalDate end = (LocalDate)range.getValue();
        if (end == null && LogORMConfig.isOptimizationSetNowAsEnd()) {
            end = LocalDate.now();
        }
        if (start == null || end == null) {
            return this.getIndexAllName(schema, table, date);
        }
        IndexNameGenerator indexNameGenerator = new IndexNameGenerator(start, end);
        return indexNameGenerator.generate(schema, table);
    }

    public static class IndexNameGenerator {
        private final LocalDate start;
        private final LocalDate end;

        public IndexNameGenerator(LocalDate start, LocalDate end) {
            this.start = start;
            this.end = end;
        }

        public String generate(String schema, String table) {
            String startDateString = DATE_FORMATTER.format(this.start);
            String endDateString = DATE_FORMATTER.format(this.end);
            int length = startDateString.length();
            int endIndex = -1;
            int i = 0;
            while (i < length && startDateString.charAt(i) == endDateString.charAt(i)) {
                endIndex = i++;
            }
            if (endIndex < 0) {
                return String.format("%s-%s-*", schema, table);
            }
            String common = startDateString.substring(0, endIndex + 1);
            if (common.length() < startDateString.length()) {
                common = common + '*';
            }
            return String.format("%s-%s-%s", schema, table, common);
        }
    }
}

