/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logorm.client.DeleteByQueryResponse;
import kd.bos.logorm.client.es.BoolQuery;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.TranslateAction;
import kd.bos.logorm.client.es.TranslateResponse;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.request.DeleteRequest;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.ObjectMapperUtils;
import kd.bos.orm.query.QFilter;

public class DeleteAction
extends ESAction<DeleteByQueryResponse> {
    private final DeleteRequest request;

    public DeleteAction(RequestContext context, ESDataSource ds, DeleteRequest request, String tenantId, String accountId) {
        super(context, ds, tenantId, accountId);
        this.request = request;
    }

    @Override
    protected HttpRequest build() {
        String data;
        HttpRequest httpRequest = this.createRequest(this.getIndexAllName(this.request.getTable(), new Date()) + "/_delete_by_query", HttpRequest.ContentType.JSON, HttpRequest.RequestType.POST);
        ArrayList<String> qFilters2String = null;
        if (this.context.isDebug()) {
            qFilters2String = new ArrayList<String>(this.request.getWhere().length);
            for (QFilter qFilter : this.request.getWhere()) {
                qFilters2String.add(qFilter.toString());
            }
        }
        if (LogORMConfig.isUseServerTranslateFilter()) {
            TranslateAction translateAction = new TranslateAction(this.context, this.ds, this.tenantId, this.accountId, this.request.getTable(), this.request.getWhere());
            TranslateResponse response = (TranslateResponse)translateAction.execute();
            data = this.object2Json(response.getQuery());
        } else {
            Calendar calendar = Calendar.getInstance(this.context.getTimeZone());
            BoolQuery boolQuery = BoolQuery.create(this.request.getWhere(), calendar, false);
            data = this.object2Json(boolQuery);
        }
        httpRequest.setData(data);
        if (this.context.isDebug()) {
            this.context.getDebugLog().info("QFilter[] => BoolQuery : {} => {}", qFilters2String, (Object)data);
        }
        return httpRequest;
    }

    @Override
    protected DeleteByQueryResponse parse(String result) throws JsonProcessingException {
        ObjectMapper objectMapper = ObjectMapperUtils.getMapper(false);
        JsonNode root = objectMapper.readTree(result);
        JsonNode deleted = root.get("deleted");
        if (deleted != null) {
            return new DeleteByQueryResponse(deleted.asInt());
        }
        throw LogORMExceptionFactory.createWithContext("Delete fail, server not return deleted count.");
    }
}

