/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Calendar;
import java.util.Iterator;
import kd.bos.logorm.client.RowContainer;
import kd.bos.logorm.client.es.CursorAction;
import kd.bos.logorm.client.es.ESQueryCompletionResponse;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.request.RequestContext;

public class ESRowContainer
implements RowContainer {
    private final RequestContext context;
    private final Codec<?>[] codecs;
    private final String tenantId;
    private final String accountId;
    private final Calendar calendar;
    private String cursorKey;
    private Iterator<JsonNode> rows;
    private final ESDataSource ds;

    public ESRowContainer(RequestContext context, ESDataSource ds, Codec<?>[] codecs, String tenantId, String accountId, String cursorKey, Iterator<JsonNode> rows) {
        this.context = context;
        this.codecs = codecs;
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.cursorKey = cursorKey;
        this.rows = rows;
        this.calendar = Calendar.getInstance(context.getTimeZone());
        this.ds = ds;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.rows.hasNext();
        if (hasNext) {
            return true;
        }
        if (this.cursorKey == null) {
            return false;
        }
        CursorAction request = new CursorAction(this.context, this.ds, this.tenantId, this.accountId, this.cursorKey);
        try {
            ESQueryCompletionResponse response = (ESQueryCompletionResponse)request.execute();
            if (response == null || response.getRowResult() == null) {
                return false;
            }
            ESRowContainer rowContainer = response.getRowResult();
            this.cursorKey = rowContainer.cursorKey;
            this.rows = rowContainer.rows;
            return this.rows.hasNext();
        }
        catch (Exception e) {
            throw LogORMExceptionFactory.create("Use cursor to fetch data fail," + e.getMessage(), e);
        }
    }

    @Override
    public Object[] next() {
        if (!this.hasNext()) {
            throw LogORMExceptionFactory.create("Don't have more rows,please call hasNext before next.");
        }
        Iterator jsonRow = this.rows.next().elements();
        Object[] row = new Object[this.codecs.length];
        int i = 0;
        while (jsonRow.hasNext()) {
            JsonNode node = (JsonNode)jsonRow.next();
            row[i] = this.codecs[i].decode(node, this.calendar);
            ++i;
        }
        return row;
    }
}

