/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import kd.bos.logorm.client.CompletionResponse;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;

public class FlushIndexAction
extends ESAction<CompletionResponse> {
    private final String entityName;
    private final Date date;
    private final boolean flushAll;

    public FlushIndexAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String entityName, Date date) {
        super(context, ds, tenantId, accountId);
        this.entityName = entityName;
        this.date = date;
        this.flushAll = false;
    }

    public FlushIndexAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String entityName, Date date, boolean flushAll) {
        super(context, ds, tenantId, accountId);
        this.entityName = entityName;
        this.date = date;
        this.flushAll = flushAll;
    }

    @Override
    protected HttpRequest build() {
        DataEntityMetaProvider dataEntityMetaProvider = this.context.getDataEntityMetaProvider();
        EntityMetadataContext metadataContext = dataEntityMetaProvider.getEntityMetadata(this.entityName);
        return this.createRequest(String.format("/%s/_flush", this.flushAll ? this.getIndexAllName(metadataContext.getTableName(), this.date) : this.getIndexSliceName(metadataContext.getTableName(), this.date)), null, HttpRequest.RequestType.POST);
    }

    @Override
    protected CompletionResponse parse(String result) throws JsonProcessingException {
        return new CompletionResponse(){};
    }
}

