/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.client.es.CreateMappingAction;
import kd.bos.logorm.client.es.FlushIndexAction;
import kd.bos.logorm.client.es.IndexExistAction;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.request.RequestContext;
import kd.bos.threads.ThreadPools;

public class IndexExistManager {
    private static final Log log = LogFactory.getLog((String)"LogORM");
    private static final Map<String, AtomicBoolean> INDEX_EXIST_LOCK = new ConcurrentHashMap<String, AtomicBoolean>();

    private IndexExistManager() {
    }

    public static void asyncCreateMappingIfNotExist(RequestContext context, ESDataSource ds, String tenantId, String accountId, String tableName, String entityName, Date date) {
        ThreadPools.executeOnce((String)("LogORM-CreateMappingRequest-" + entityName), () -> IndexExistManager.createMappingIfNotExist(context, ds, tenantId, accountId, tableName, entityName, date));
    }

    public static void createMappingIfNotExist(RequestContext context, ESDataSource ds, String tenantId, String accountId, String tableName, String entityName, Date date) {
        if ("t_isv_1".equalsIgnoreCase(tableName)) {
            log.warn("Create elastic mapping fail,the table name is default value:t_isv_1");
            return;
        }
        IndexExistAction indexExistRequest = new IndexExistAction(context, ds, tenantId, accountId, tableName, date);
        if (LogORMConfig.isAlwaysValidIndexOnSave()) {
            AtomicBoolean exist = new AtomicBoolean(false);
            IndexExistManager.createMappingIfNotExist0(exist, indexExistRequest, context, ds, tenantId, accountId, entityName, 5, date);
            return;
        }
        AtomicBoolean mappingExist = INDEX_EXIST_LOCK.computeIfAbsent(IndexExistManager.createKey(tenantId, accountId, indexExistRequest.getSliceTableName()), k -> new AtomicBoolean(false));
        if (mappingExist.get()) {
            return;
        }
        IndexExistManager.createMappingIfNotExist0(mappingExist, indexExistRequest, context, ds, tenantId, accountId, entityName, 0, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createMappingIfNotExist0(AtomicBoolean mappingExist, IndexExistAction indexExistAction, RequestContext context, ESDataSource ds, String tenantId, String accountId, String entityName, int retryCount, Date date) {
        AtomicBoolean atomicBoolean = mappingExist;
        synchronized (atomicBoolean) {
            if (mappingExist.get()) {
                return;
            }
            try {
                indexExistAction.execute();
                mappingExist.set(true);
            }
            catch (Exception ex) {
                CreateMappingAction createMappingRequest = new CreateMappingAction(context, ds, tenantId, accountId, entityName, date);
                try {
                    createMappingRequest.execute();
                    FlushIndexAction flushIndexAction = new FlushIndexAction(context, ds, tenantId, accountId, entityName, date);
                    flushIndexAction.execute();
                    mappingExist.set(true);
                }
                catch (Exception createMappingEx) {
                    log.warn("Try to create mapping error,retry count:" + retryCount + ": " + ex.getMessage(), (Throwable)ex);
                    if (retryCount >= 5) {
                        throw LogORMExceptionFactory.createWithContext("Try to create mapping error: " + createMappingEx.getMessage(), createMappingEx);
                    }
                    IndexExistManager.createMappingIfNotExist0(mappingExist, indexExistAction, context, ds, tenantId, accountId, entityName, ++retryCount, date);
                }
            }
        }
    }

    private static String createKey(String tenantId, String accountId, String tableName) {
        return String.format("%s#%s#%s", tenantId, accountId, tableName);
    }

    public static void clearIndexExistCache() {
        INDEX_EXIST_LOCK.clear();
    }
}

