/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import java.util.Date;
import kd.bos.logorm.client.es.DayIndexSliceStrategyImpl;
import kd.bos.logorm.client.es.MonthIndexSliceStrategyImpl;
import kd.bos.logorm.client.es.NoneIndexSliceStrategyImpl;
import kd.bos.logorm.client.es.YearIndexSliceStrategyImpl;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public interface IndexSliceStrategy {
    public String getIndexSliceName(String var1, String var2, Date var3);

    public String getIndexAllName(String var1, String var2, Date var3);

    public String getIndexAllName(String var1, String var2, Date var3, DateInterval var4);

    default public String getIndexSchemaName(String schema) {
        return schema + "-*";
    }

    public static IndexSliceStrategy of(Strategy strategy) {
        switch (strategy) {
            case DAY: {
                return DayIndexSliceStrategyImpl.INSTANCE;
            }
            case NONE: {
                return NoneIndexSliceStrategyImpl.INSTANCE;
            }
            case YEAR: {
                return YearIndexSliceStrategyImpl.INSTANCE;
            }
            case MONTH: {
                return MonthIndexSliceStrategyImpl.INSTANCE;
            }
        }
        throw LogORMExceptionFactory.createWithContext("Unknown index slice strategy: %s.", new Object[]{strategy});
    }

    public static enum Strategy {
        NONE,
        DAY,
        MONTH,
        YEAR;

    }
}

