/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import kd.bos.logorm.client.es.ElasticSearchObjectSerializable;
import kd.bos.logorm.codec.DataType;

public class MappingPropertiesObject
implements ElasticSearchObjectSerializable {
    private final String[] columns;
    private final DataType[] dataTypes;

    public MappingPropertiesObject(String[] columns, DataType[] dataTypes) {
        this.columns = columns;
        this.dataTypes = dataTypes;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeObjectFieldStart("properties");
        for (int i = 0; i < this.columns.length; ++i) {
            jgen.writeObjectFieldStart(this.columns[i]);
            jgen.writeObjectField("type", (Object)this.dataTypes[i].getEsType());
            if (this.dataTypes[i] == DataType.TEXT) {
                jgen.writeObjectFieldStart("fields");
                jgen.writeObjectFieldStart("raw");
                jgen.writeObjectField("type", (Object)"keyword");
                jgen.writeObjectField("ignore_above", (Object)"2000");
                jgen.writeEndObject();
                jgen.writeEndObject();
            } else if (this.dataTypes[i] == DataType.KEYWORD) {
                jgen.writeObjectField("ignore_above", (Object)"2000");
                jgen.writeObjectField("null_value", (Object)" ");
            }
            jgen.writeEndObject();
        }
        jgen.writeEndObject();
        jgen.writeEndObject();
    }
}

