/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.logorm.client.es.IndexSliceStrategy;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.config.LogORMConfig;

public class MonthIndexSliceStrategyImpl
implements IndexSliceStrategy {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
    static final IndexSliceStrategy INSTANCE = new MonthIndexSliceStrategyImpl();

    @Override
    public String getIndexSliceName(String schema, String table, Date date) {
        LocalDate now = date.toInstant().atZone(LogORMConfig.getTimeZoneId()).toLocalDate();
        return String.format("%s-%s-%s", schema, table, now.format(DATE_FORMATTER));
    }

    @Override
    public String getIndexAllName(String schema, String table, Date date) {
        return String.format("%s-%s-*", schema, table);
    }

    @Override
    public String getIndexAllName(String schema, String table, Date date, DateInterval interval) {
        return this.getIndexAllName(schema, table, date);
    }
}

