/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Calendar;
import kd.bos.logorm.client.es.ElasticSearchObjectSerializable;
import kd.bos.logorm.codec.CodecFactory;
import kd.bos.logorm.exception.LogORMExceptionFactory;

class RangeObject
implements ElasticSearchObjectSerializable {
    private String key;
    private Object value;
    private String cp;
    private Calendar calendar;

    public RangeObject(String key, String qcp, Object value, Calendar calendar) {
        this.key = key;
        this.value = value;
        switch (qcp) {
            case ">": {
                this.cp = "gt";
                break;
            }
            case "<": {
                this.cp = "lt";
                break;
            }
            case ">=": {
                this.cp = "gte";
                break;
            }
            case "<=": {
                this.cp = "lte";
                break;
            }
            default: {
                throw LogORMExceptionFactory.createWithContext("Unsupported qcp: %s for RangeObject.", qcp);
            }
        }
        this.calendar = calendar;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName("range");
        jgen.writeStartObject();
        jgen.writeFieldName(this.key);
        jgen.writeStartObject();
        jgen.writeObjectField(this.cp, CodecFactory.get(this.value).encode(this.value, this.calendar));
        jgen.writeEndObject();
        jgen.writeEndObject();
        jgen.writeEndObject();
    }
}

