/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es.monitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logorm.client.es.ESAction;
import kd.bos.logorm.client.es.monitor.IndexInfoResponse;
import kd.bos.logorm.datasource.es.ESDataSource;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.HttpRequest;
import kd.bos.logorm.utils.ObjectMapperUtils;

public class CatIndicesAction
extends ESAction<IndexInfoResponse> {
    private final String index;
    private final Map<String, String> queryParams;

    public CatIndicesAction(String index, RequestContext context, ESDataSource ds, String tenantId, String accountId) {
        super(context, ds, tenantId, accountId);
        this.index = index;
        this.queryParams = new HashMap<String, String>(0);
        this.queryParams.put("v", null);
        this.queryParams.put("format", "json");
        this.queryParams.put("bytes", "b");
        this.queryParams.put("s", "docs.count:desc");
    }

    public CatIndicesAction(RequestContext context, ESDataSource ds, String tenantId, String accountId, String index, Map<String, String> queryParams) {
        super(context, ds, tenantId, accountId);
        this.index = index;
        this.queryParams = queryParams;
    }

    @Override
    protected HttpRequest build() {
        return this.createRequest(this.appendParam(String.format("/_cat/indices/%s", this.index), this.queryParams, true), null, HttpRequest.RequestType.GET);
    }

    private String appendParam(String url, Map<String, String> queryParams, boolean cover) {
        HashMap<String, String> defaultParams = new HashMap<String, String>();
        int idx = url.indexOf("?");
        if (idx >= 0) {
            String q = url.substring(idx + 1);
            for (String s : q.split("&")) {
                String[] kv = s.split("=");
                if (kv.length > 1) {
                    defaultParams.put(kv[0], kv[1]);
                    continue;
                }
                defaultParams.put(s, null);
            }
        }
        queryParams.forEach((k, v) -> {
            if (cover) {
                defaultParams.put((String)k, (String)v);
            } else if (!defaultParams.containsKey(k)) {
                defaultParams.put((String)k, (String)v);
            }
        });
        ArrayList query = new ArrayList(defaultParams.size());
        defaultParams.forEach((k, v) -> {
            if (v == null) {
                query.add(k);
            } else {
                query.add(k + '=' + v);
            }
        });
        url = idx < 0 ? url + '?' : url.substring(0, idx + 1);
        url = url + String.join((CharSequence)"&", query);
        return url;
    }

    @Override
    protected IndexInfoResponse parse(String result) throws JsonProcessingException {
        ArrayNode root = (ArrayNode)ObjectMapperUtils.getMapper(false).readTree(result);
        IndexInfoResponse response = new IndexInfoResponse();
        for (JsonNode node : root) {
            IndexInfoResponse.Index idx = new IndexInfoResponse.Index();
            String health = node.get("health").asText();
            String status = node.get("status").asText();
            switch (health) {
                case "green": {
                    idx.setHealth(1);
                    break;
                }
                case "yellow": {
                    idx.setHealth(2);
                    break;
                }
                case "red": {
                    idx.setHealth(3);
                    break;
                }
                default: {
                    idx.setHealth(-1);
                }
            }
            switch (status) {
                case "open": {
                    idx.setStatus(1);
                    break;
                }
                case "close": {
                    idx.setStatus(2);
                    break;
                }
                default: {
                    idx.setStatus(-1);
                }
            }
            idx.setIndexName(node.get("index").asText());
            idx.setUuid(node.get("uuid").asText());
            idx.setPri(node.get("pri").asText());
            idx.setRep(node.get("rep").asText());
            String docCount = node.get("docs.count").asText();
            if (docCount == null || "null".equalsIgnoreCase(docCount.trim())) {
                idx.setDocsCount(0);
            } else {
                idx.setDocsCount(Integer.parseInt(docCount));
            }
            idx.setDocsDeleted(node.get("docs.deleted").asText());
            idx.setStoreSize(node.get("store.size").asText());
            idx.setPriStoreSize(node.get("pri.store.size").asText());
            response.add(idx);
        }
        return response;
    }
}

