/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es.optimization;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.client.es.optimization.PointDateInterval;
import kd.bos.logorm.client.es.optimization.RangeDateInterval;
import kd.bos.util.Pair;

public class ListPointDateInterval
implements DateInterval {
    private final List<PointDateInterval> points = new ArrayList<PointDateInterval>();

    public void addPoint(PointDateInterval interval) {
        this.points.add(interval);
    }

    @Override
    public DateInterval and(DateInterval target) {
        Pair<LocalDate, LocalDate> pair = this.getDateRange();
        if (pair == null) {
            return target;
        }
        if (((LocalDate)pair.getKey()).equals(pair.getValue())) {
            return new PointDateInterval((LocalDate)pair.getKey()).and(target);
        }
        return new RangeDateInterval((LocalDate)pair.getKey(), (LocalDate)pair.getValue()).and(target);
    }

    @Override
    public DateInterval or(DateInterval target) {
        Pair<LocalDate, LocalDate> pair = this.getDateRange();
        if (pair == null) {
            return target;
        }
        if (((LocalDate)pair.getKey()).equals(pair.getValue())) {
            return new PointDateInterval((LocalDate)pair.getKey()).or(target);
        }
        return new RangeDateInterval((LocalDate)pair.getKey(), (LocalDate)pair.getValue()).or(target);
    }

    @Override
    public Pair<LocalDate, LocalDate> getDateRange() {
        if (this.points.isEmpty()) {
            return null;
        }
        LocalDate start = null;
        LocalDate end = null;
        HashSet<LocalDate> dates = new HashSet<LocalDate>(this.points.size());
        for (PointDateInterval pointDateInterval : this.points) {
            dates.add(pointDateInterval.getDate());
        }
        for (LocalDate localDate : dates) {
            if (start == null) {
                start = localDate;
            }
            if (end == null) {
                end = localDate;
            }
            if (localDate.compareTo(start) < 0) {
                start = localDate;
            }
            if (localDate.compareTo(end) <= 0) continue;
            end = localDate;
        }
        return new Pair(start, end);
    }
}

