/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.client.es.optimization;

import java.time.LocalDate;
import kd.bos.logorm.client.es.optimization.DateInterval;
import kd.bos.logorm.client.es.optimization.DirectionDateInterval;
import kd.bos.logorm.client.es.optimization.PointDateInterval;
import kd.bos.logorm.client.es.optimization.UnlimitedDateInterval;
import kd.bos.util.Pair;

public class RangeDateInterval
implements DateInterval {
    private LocalDate start;
    private LocalDate end;

    public RangeDateInterval(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    public boolean isUnlimited() {
        return this.start.compareTo(this.end) > 0;
    }

    public boolean isPoint() {
        return this.start.compareTo(this.end) == 0;
    }

    @Override
    public DateInterval and(DateInterval target) {
        if (this.isUnlimited()) {
            return UnlimitedDateInterval.UNLIMITED.and(target);
        }
        if (this.isPoint()) {
            return new PointDateInterval(this.start).and(target);
        }
        if (target instanceof DirectionDateInterval) {
            DirectionDateInterval directionDateInterval = (DirectionDateInterval)target;
            if (directionDateInterval.getDate().compareTo(this.start) < 0 || directionDateInterval.getDate().compareTo(this.end) > 0) {
                return this;
            }
            if (directionDateInterval.getDirection() == DirectionDateInterval.Direction.LEFT) {
                this.end = this.end.compareTo(directionDateInterval.getDate()) < 0 ? this.end : directionDateInterval.getDate();
            } else {
                this.start = this.start.compareTo(directionDateInterval.getDate()) > 0 ? this.start : directionDateInterval.getDate();
            }
            return this;
        }
        if (target instanceof RangeDateInterval) {
            RangeDateInterval rangeDateInterval = (RangeDateInterval)target;
            if (rangeDateInterval.isUnlimited()) {
                return this.and(UnlimitedDateInterval.UNLIMITED);
            }
            if (rangeDateInterval.isPoint()) {
                return this.and(new PointDateInterval(rangeDateInterval.getStart()));
            }
            if (this.start.compareTo(rangeDateInterval.end) > 0 || this.end.compareTo(rangeDateInterval.start) < 0) {
                return this;
            }
            this.start = this.start.compareTo(rangeDateInterval.start) > 0 ? this.start : rangeDateInterval.start;
            this.end = this.end.compareTo(rangeDateInterval.end) < 0 ? this.end : rangeDateInterval.end;
            return this;
        }
        return target.and(this);
    }

    @Override
    public DateInterval or(DateInterval target) {
        if (this.isUnlimited()) {
            return UnlimitedDateInterval.UNLIMITED.or(target);
        }
        if (this.isPoint()) {
            return new PointDateInterval(this.start).or(target);
        }
        if (target instanceof DirectionDateInterval) {
            DirectionDateInterval directionDateInterval = (DirectionDateInterval)target;
            LocalDate date = directionDateInterval.getDirection() == DirectionDateInterval.Direction.LEFT ? (this.end.compareTo(directionDateInterval.getDate()) > 0 ? this.end : directionDateInterval.getDate()) : (this.start.compareTo(directionDateInterval.getDate()) < 0 ? this.start : directionDateInterval.getDate());
            return new DirectionDateInterval(date, directionDateInterval.getDirection());
        }
        if (target instanceof RangeDateInterval) {
            LocalDate s = this.start.compareTo(((RangeDateInterval)target).start) < 0 ? this.start : ((RangeDateInterval)target).start;
            LocalDate e = this.end.compareTo(((RangeDateInterval)target).end) > 0 ? this.end : ((RangeDateInterval)target).end;
            return new RangeDateInterval(s, e);
        }
        if (target instanceof PointDateInterval) {
            LocalDate date = ((PointDateInterval)target).getDate();
            if (this.start.compareTo(date) <= 0 && this.end.compareTo(date) >= 0) {
                return this;
            }
            if (this.start.compareTo(date) > 0) {
                this.start = date;
            } else if (this.end.compareTo(date) < 0) {
                this.end = date;
            }
            return this;
        }
        return target.or(this);
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    @Override
    public Pair<LocalDate, LocalDate> getDateRange() {
        if (this.isUnlimited()) {
            return UnlimitedDateInterval.UNLIMITED.getDateRange();
        }
        return new Pair((Object)this.start, (Object)this.end);
    }
}

