/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.codec.DateCodec;
import kd.bos.logorm.codec.DoubleCodec;
import kd.bos.logorm.codec.IntCodec;
import kd.bos.logorm.codec.LongCodec;
import kd.bos.logorm.codec.NullCodec;
import kd.bos.logorm.codec.StringCodec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class CodecFactory {
    private static final LongCodec LONG_CODEC = new LongCodec();
    private static final StringCodec STRING_CODEC = new StringCodec();
    private static final IntCodec INT_CODEC = new IntCodec();
    private static final NullCodec NULL_CODEC = new NullCodec();
    private static final DoubleCodec DOUBLE_CODEC = new DoubleCodec();
    private static final DateCodec DATE_CODEC = new DateCodec();

    private CodecFactory() {
    }

    public static Codec<?> getBySQLType(int sqlType) {
        switch (sqlType) {
            case -9: 
            case 12: 
            case 2005: 
            case 2011: {
                return STRING_CODEC;
            }
            case -6: 
            case 4: 
            case 5: {
                return INT_CODEC;
            }
            case 3: 
            case 6: 
            case 8: {
                return DOUBLE_CODEC;
            }
            case -5: {
                return LONG_CODEC;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE_CODEC;
            }
            case 0: {
                return NULL_CODEC;
            }
        }
        throw LogORMExceptionFactory.create("Unsupported sql type : " + sqlType);
    }

    public static Codec<?> get(Object value) {
        if (value instanceof String) {
            return STRING_CODEC;
        }
        if (value instanceof Long) {
            return LONG_CODEC;
        }
        if (value instanceof Integer) {
            return INT_CODEC;
        }
        if (value == null) {
            return NULL_CODEC;
        }
        if (value instanceof Date) {
            return DATE_CODEC;
        }
        if (value instanceof Float) {
            return DOUBLE_CODEC;
        }
        if (value instanceof Double) {
            return DOUBLE_CODEC;
        }
        if (value instanceof BigDecimal) {
            return DOUBLE_CODEC;
        }
        throw LogORMExceptionFactory.create("Not supported value type : " + value.getClass().getName());
    }

    public static Codec<?> getByDataType(String dataType) {
        switch (dataType) {
            case "text": 
            case "keyword": {
                return STRING_CODEC;
            }
            case "long": {
                return LONG_CODEC;
            }
            case "short": 
            case "integer": {
                return INT_CODEC;
            }
            case "float": 
            case "double": {
                return DOUBLE_CODEC;
            }
            case "date": 
            case "datetime": {
                return DATE_CODEC;
            }
        }
        throw LogORMExceptionFactory.create("Unsupported data type: " + dataType + '.');
    }
}

