/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.math.BigDecimal;
import java.util.Calendar;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class DoubleCodec
implements Codec<BigDecimal> {
    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        throw LogORMExceptionFactory.create("Encode double value as text fail,unsupported value type:" + value.getClass().getName());
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (Exception ex) {
                throw LogORMExceptionFactory.create("Unknown value for DoubleCodec:" + value, ex);
            }
        }
        if (value == null) {
            return null;
        }
        throw LogORMExceptionFactory.create("Unknown value for DoubleCodec:" + value);
    }

    @Override
    public BigDecimal decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        return BigDecimal.valueOf(src.asDouble());
    }
}

