/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Calendar;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.utils.ObjectTypeUtils;

public class IntCodec
implements Codec<Integer> {
    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        throw LogORMExceptionFactory.create("IntCodec not supported encode value type:" + ObjectTypeUtils.getTypeName(value) + '.');
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (Exception ex) {
                throw LogORMExceptionFactory.create("IntCodec can't encode value: " + value + '.', ex);
            }
        }
        if (value == null) {
            return null;
        }
        throw LogORMExceptionFactory.create("IntCodec not supported encode value type: " + ObjectTypeUtils.getTypeName(value) + '.');
    }

    @Override
    public Integer decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        return src.asInt();
    }
}

