/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Calendar;
import kd.bos.logorm.codec.Codec;
import kd.bos.logorm.exception.LogORMExceptionFactory;

public class StringCodec
implements Codec<String> {
    @Override
    public String encodeAsText(Object value, Calendar cal) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return '\'' + value.toString() + '\'';
        }
        throw LogORMExceptionFactory.create("Encode string value as text fail,unsupported value type:" + value.getClass().getName());
    }

    @Override
    public Object encode(Object value, Calendar cal) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String decode(JsonNode src, Calendar cal) {
        if (src == null) {
            return null;
        }
        if (src instanceof NullNode) {
            return null;
        }
        return src.asText();
    }
}

