/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.datasource.dc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.archive.MCArchive;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.RestClientFactory;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.ConfigurationUtil;

public class MCApiZKImpl
implements MCApi {
    private static final Log log = LogFactory.getLog(MCApiZKImpl.class);
    private static final Map<String, ESConfig> CACHE = new ConcurrentHashMap<String, ESConfig>();
    private static final ConcurrentHashMap<String, Object> TENANT_LOCK = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> TENANT_UPDATE = new ConcurrentHashMap();
    private static final MCApiZKImpl INSTANCE = new MCApiZKImpl();
    private boolean checkAccountNumberTag = false;
    private RuntimeException checkException = null;

    public static MCApiZKImpl getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public ESConfig get(String tenantId, String accountId) {
        ESConfig config = this.get0(tenantId, accountId, true);
        if (config == null || config.getCluster() == null) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Unknown ElasticSearch data source, rc:%s#%s.", tenantId, accountId)});
        }
        return config;
    }

    private void checkAccountNumber() {
        if (this.checkException != null) {
            throw this.checkException;
        }
        if (this.checkAccountNumberTag) {
            return;
        }
        this.checkAccountNumber0();
    }

    private synchronized void checkAccountNumber0() {
        List tenantInfoList;
        if (this.checkAccountNumberTag) {
            return;
        }
        try {
            tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
        }
        catch (Exception ignored) {
            return;
        }
        HashSet<String> accountSet = new HashSet<String>();
        for (TenantInfo tenantInfo : tenantInfoList) {
            List dcs = MCArchive.__getAllDCInfo((String)tenantInfo.getId());
            if (dcs == null) continue;
            for (Map dc : dcs) {
                String accountNumber = ((String)dc.get("datacenternumber")).trim();
                String schema = accountNumber.toLowerCase(Locale.ENGLISH);
                if (accountSet.contains(schema)) {
                    this.checkException = LogORMExceptionFactory.createWithContext("duplicate account number: " + accountNumber);
                    throw this.checkException;
                }
                accountSet.add(schema);
            }
        }
        this.checkAccountNumberTag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ESConfig get0(String tenantId, String accountId, boolean check) {
        Object lock;
        this.checkAccountNumber();
        String key = String.format("%s#%s", tenantId, accountId);
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        TENANT_UPDATE.computeIfAbsent(tenantId, k -> {
            ConfigurationUtil.observeString((String)String.format("mc.tenant.%s.data", tenantId), null, s -> {
                ArrayList<String> clearKey = new ArrayList<String>(CACHE.size());
                for (String key1 : CACHE.keySet()) {
                    if (key1 == null || !key1.startsWith(k + '#')) continue;
                    clearKey.add(key1);
                }
                for (String key1 : clearKey) {
                    CACHE.remove(key1);
                }
                RestClientFactory.clearCache();
            });
            return new Object();
        });
        Object object = lock = TENANT_LOCK.computeIfAbsent(tenantId, k -> new Object());
        synchronized (object) {
            ESConfig config = CACHE.get(key);
            if (config != null) {
                return config;
            }
            List<ESConfig> configs = this.getByTenantId(tenantId, check);
            for (ESConfig c : configs) {
                CACHE.put(String.format("%s#%s", c.getTenantId(), c.getAccountId()), c);
            }
            return CACHE.get(key);
        }
    }

    private List<ESConfig> getByTenantId(String tenantId, boolean check) {
        List dcs = MCArchive.__getAllDCInfo((String)tenantId);
        if (dcs == null) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Get tenant data center info not exist, tenantId: %s.", tenantId)});
        }
        ArrayList<ESConfig> configs = new ArrayList<ESConfig>(dcs.size());
        for (Map dc : dcs) {
            ESConfig config;
            boolean enableElastic;
            String accountNumber = (String)dc.get("datacenternumber");
            String accountId = (String)dc.get("datacenterid");
            accountNumber = accountNumber.trim();
            accountId = accountId.trim();
            try {
                enableElastic = Objects.isNull(dc.get("isEslogEnable")) ? false : (Boolean)dc.get("isEslogEnable");
            }
            catch (Exception ex) {
                log.error("MC config error: isEslogEnable not found.");
                throw LogORMExceptionFactory.createWithContext("MC config error: isEslogEnable not found.", ex);
            }
            String schema = accountNumber;
            schema = schema.toLowerCase(Locale.ENGLISH);
            if (!enableElastic) {
                config = new ESConfig(schema, null, null, tenantId, accountId, false);
            } else {
                Map esDatasourceConfig = Objects.isNull(dc.get("esCluster")) ? null : (Map)dc.get("esCluster");
                ESConfig.ESCluster cluster = this.parseConfig(esDatasourceConfig, check);
                List archiveConfig = Objects.isNull(dc.get("esArchiveCluster")) ? null : (List)dc.get("esArchiveCluster");
                HashMap<String, ESConfig.ArchiveESInfo> archiveInfo = new HashMap<String, ESConfig.ArchiveESInfo>(8);
                if (archiveConfig != null && !archiveConfig.isEmpty()) {
                    archiveInfo = new HashMap(archiveConfig.size());
                    for (Map item : archiveConfig) {
                        String archiveKey = (String)item.get("key");
                        String archiveName = (String)item.get("name");
                        Map archiveItemConfigList = (Map)item.get("esCluster");
                        ESConfig.ESCluster archiveCluster = this.parseConfig(archiveItemConfigList, check);
                        archiveInfo.put(archiveKey.toLowerCase(), new ESConfig.ArchiveESInfo(archiveKey, archiveName, archiveCluster));
                    }
                }
                config = new ESConfig(schema, cluster, archiveInfo, tenantId, accountId, enableElastic);
            }
            configs.add(config);
        }
        return configs;
    }

    private ESConfig.ESCluster parseConfig(Map<String, Object> config, boolean check) {
        if (config == null || config.isEmpty()) {
            return null;
        }
        String name = (String)config.get("name");
        String number = (String)config.get("number");
        String username = (String)config.get("username");
        String np1 = Encrypters.decode((String)((String)config.get("passwd")));
        List urls = (List)config.get("urls");
        ESConfig.ESCluster cluster = new ESConfig.ESCluster(name, number, username, np1);
        if (urls != null && urls.size() > 0) {
            for (Map url : urls) {
                cluster.addURL((String)url.get("schema"), (String)url.get("ip"), (Integer)url.get("port"));
            }
        }
        if (check) {
            cluster.check();
        }
        return cluster;
    }

    @Override
    public boolean enableElastic(String tenantId, String accountId) {
        ESConfig config = this.get0(tenantId, accountId, false);
        if (config == null) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{String.format("Unknown datasource, rc:%s#%s.", tenantId, accountId)});
        }
        return config.isEnableElastic();
    }
}

