/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.id.ID;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.DynamicPropertyValid;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.logorm.request.BatchSaveRequest;
import kd.bos.logorm.utils.ObjectTypeUtils;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.datamanager.SimpleColumnValuePair;

public class BatchSaveActionBuilder {
    private final DynamicPropertyValid propertyValid = DynamicPropertyValid.getInstance();
    private final List<DynamicObject> objects;
    private final IDataEntityType dt;
    private final BatchSaveRequest.Operator operator;
    private final DataEntityMetaProvider dataEntityMetaProvider;

    public BatchSaveActionBuilder(List<DynamicObject> objects, BatchSaveRequest.Operator operator, DataEntityMetaProvider dataEntityMetaProvider) {
        this.objects = objects;
        this.dt = objects.get(0).getDataEntityType();
        this.operator = operator;
        this.dataEntityMetaProvider = dataEntityMetaProvider;
    }

    public BatchSaveRequest build() {
        this.propertyValid.check(this.objects.get(0));
        EntityMetadataContext entityMetadataContext = this.dataEntityMetaProvider.getEntityMetadata(this.dt.getName());
        String[] columnNames = entityMetadataContext.getColumnNames();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.objects.size());
        ArrayList<BitSet> bitSets = new ArrayList<BitSet>(this.objects.size());
        ArrayList<Date> opdateSets = new ArrayList<Date>(this.objects.size());
        ISimpleProperty primaryKeyProperty = this.dt.getPrimaryKey();
        DataEntityPropertyCollection properties = this.dt.getProperties();
        int propertySize = properties.size();
        int rowIdx = 0;
        for (DynamicObject object : this.objects) {
            Object[] row = new Object[propertySize];
            BitSet bitSet = new BitSet(propertySize);
            Object primary = primaryKeyProperty.getValueFast((Object)object);
            if (primary == null || Long.valueOf(0L).equals(primary)) {
                primaryKeyProperty.setValueFast((Object)object, (Object)ID.genLongId());
            }
            if (!(primary instanceof Long)) {
                throw LogORMExceptionFactory.createWithContext("Batch %s fail, row: %d primary type is %s, the primary type must be long.", this.operator.name(), rowIdx + 1, ObjectTypeUtils.getTypeName(primary));
            }
            Date opdate = PresetPropertyUtils.getOpDate(object);
            if (opdate == null) {
                throw LogORMExceptionFactory.createWithContext("Batch %s fail, row: %d opdate is null.", this.operator.name(), rowIdx + 1);
            }
            opdateSets.add(opdate);
            if (this.operator == BatchSaveRequest.Operator.INSERT) {
                bitSet.set(0, columnNames.length, true);
                for (int i = 0; i < propertySize; ++i) {
                    Object value = ((IDataEntityProperty)properties.get(i)).getValueFast((Object)object);
                    EntityProperty property = entityMetadataContext.getEntityProperty(i);
                    if (property.hasColumnName()) {
                        row[i] = property.convertAndGetDefaultValueIfNull(this.toSimpleColumnValue(value, property));
                        continue;
                    }
                    bitSet.set(property.getOrdinal(), false);
                }
            } else {
                List dirtyProperties = this.dt.getDirtyProperties((Object)object);
                dirtyProperties.add(this.dt.getPrimaryKey());
                for (IDataEntityProperty dirtyProperty : dirtyProperties) {
                    Object value = dirtyProperty.getValueFast((Object)object);
                    int ordinal = dirtyProperty.getOrdinal();
                    EntityProperty property = entityMetadataContext.getEntityProperty(ordinal);
                    if (!property.hasColumnName()) continue;
                    row[ordinal] = property.convertAndGetValue(this.toSimpleColumnValue(value, property));
                    bitSet.set(ordinal, true);
                }
            }
            rows.add(row);
            bitSets.add(bitSet);
            ++rowIdx;
        }
        String tableName = this.dt.getAlias();
        return new BatchSaveRequest(this.dt.getName(), tableName, columnNames, entityMetadataContext.getSqlTypes(), primaryKeyProperty.getOrdinal(), this.operator, rows, bitSets, opdateSets);
    }

    private Object toSimpleColumnValue(Object value, EntityProperty property) {
        return new SimpleColumnValuePair(property.getDbMetadataColumn(), value).getValue();
    }
}

