/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.request.QueryRequest;

public class DynamicObjectCollectionBuilder {
    private final String entityName;
    private final DataEntityMetaProvider dataEntityMetaProvider;
    private final QueryRequest.SelectItem[] select;
    private final DataSet ds;

    public DynamicObjectCollectionBuilder(String entityName, DataEntityMetaProvider dataEntityMetaProvider, QueryRequest.SelectItem[] select, DataSet ds) {
        this.entityName = entityName;
        this.dataEntityMetaProvider = dataEntityMetaProvider;
        this.select = select;
        this.ds = ds;
    }

    public DynamicObjectCollection build() {
        DynamicObjectType cloneDt;
        IDataEntityProperty[] queryProperty = new IDataEntityProperty[this.select.length];
        DynamicObjectType dt = this.dataEntityMetaProvider.getDynamicObjectType(this.entityName);
        DataEntityPropertyCollection dtProperties = dt.getProperties();
        try {
            cloneDt = (DynamicObjectType)dt.clone();
        }
        catch (CloneNotSupportedException e) {
            throw LogORMExceptionFactory.createWithContext(e, "Build DynamicObjectCollection fail, clone %s error.", dt);
        }
        DynamicObjectCollection collection = new DynamicObjectCollection(cloneDt, null);
        RowMeta rowMeta = this.ds.getRowMeta();
        for (int i = 0; i < queryProperty.length; ++i) {
            QueryRequest.SelectItem p = this.select[i];
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dtProperties.get((Object)p.getPropertyName());
            if (iDataEntityProperty != null) {
                queryProperty[i] = (IDataEntityProperty)dtProperties.get((Object)p.getPropertyName());
                continue;
            }
            DataType dataType = rowMeta.getFieldDataType(i);
            DynamicSimpleProperty dynamicSimpleProperty = new DynamicSimpleProperty(p.getPropertyName(), dataType.getJavaType(), null);
            queryProperty[i] = dynamicSimpleProperty;
            cloneDt.registerSimpleProperty(dynamicSimpleProperty);
        }
        try (DataSet dataSet = this.ds;){
            while (dataSet.hasNext()) {
                DynamicObject dynamicObject = new DynamicObject(cloneDt);
                dynamicObject.beginInit();
                Row row = dataSet.next();
                for (int i = 0; i < queryProperty.length; ++i) {
                    queryProperty[i].setValueFast((Object)dynamicObject, row.get(i));
                }
                dynamicObject.getDataEntityState().setDirty(false);
                dynamicObject.endInit();
                collection.add((Object)dynamicObject);
            }
        }
        return collection;
    }
}

