/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.orm.query.multi.PropertyField;

public class EntityMetadataContext {
    private final String entityName;
    private final String tableName;
    private final EntityProperty[] properties;
    private final Map<String, EntityProperty> propertyNameMap = new HashMap<String, EntityProperty>(32);
    private final Map<String, EntityProperty> columnNameMap = new HashMap<String, EntityProperty>(32);
    private final Map<String, PropertyField> propertyFieldMapCache = new HashMap<String, PropertyField>(32);
    private final String[] columnNames;
    private final int[] sqlTypes;

    public EntityMetadataContext(String entityName, String tableName, EntityProperty[] properties) {
        this.entityName = entityName;
        this.tableName = tableName;
        this.properties = properties;
        this.columnNames = new String[this.properties.length];
        this.sqlTypes = new int[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            EntityProperty property = properties[i];
            this.propertyNameMap.put(property.getPropertyName(), property);
            this.columnNames[i] = property.getColumnName();
            this.sqlTypes[i] = property.getSqlType();
            if (!property.hasColumnName()) continue;
            this.columnNameMap.put(property.getColumnName(), property);
        }
    }

    public EntityProperty getEntityProperty(String propertyName) {
        return this.propertyNameMap.get(propertyName);
    }

    public PropertyField getPropertyField(String propertyName) {
        PropertyField pf = this.propertyFieldMapCache.get(propertyName);
        if (pf != null) {
            return pf;
        }
        EntityProperty entityProperty = this.getEntityProperty(propertyName);
        if (entityProperty == null) {
            throw LogORMExceptionFactory.createWithContext("PropertyNotFound:%s#%s.", this.entityName, propertyName);
        }
        if (!entityProperty.hasColumnName()) {
            throw LogORMExceptionFactory.create(BosRes.get((String)"bos-logormengine", (String)"PropertyDBFieldNotConfigured", (String)"Entity %1$s's property %2$s is not exists;Or the property's db field is not configured.", (Object[])new Object[]{this.entityName, propertyName}));
        }
        pf = new PropertyField(this.entityName, propertyName, null);
        pf.setField(entityProperty.getColumnName());
        this.propertyFieldMapCache.put(propertyName, pf);
        return pf;
    }

    public EntityProperty getColumnProperty(String columnName) {
        return this.columnNameMap.get(columnName);
    }

    public EntityProperty getEntityProperty(int ordinal) {
        return this.properties[ordinal];
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getNoneNullColumnNames() {
        String[] strings = this.getColumnNames();
        ArrayList<String> noneNullNames = new ArrayList<String>(strings.length);
        for (String string : strings) {
            if (string == null || string.trim().isEmpty()) continue;
            noneNullNames.add(string);
        }
        return noneNullNames.toArray(new String[0]);
    }

    public int[] getSqlTypes() {
        return this.sqlTypes;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public EntityProperty[] getProperties() {
        return this.properties;
    }

    public Map<String, EntityProperty> getPropertyNameMap() {
        return this.propertyNameMap;
    }
}

