/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.function.Supplier;
import kd.bos.dataentity.IFunction;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;

public class EntityProperty {
    private final String propertyName;
    private final String columnName;
    private final int sqlType;
    private final int ordinal;
    private final IFunction<Object, Object> convertter;
    private final Supplier<Object> defaultValueGetter;
    private final DbMetadataColumn dbMetadataColumn;

    public EntityProperty(String propertyName, String columnName, int sqlType, int ordinal, IFunction<Object, Object> convertter, Supplier<Object> defaultValueGetter, DbMetadataColumn dbMetadataColumn) {
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.ordinal = ordinal;
        this.convertter = convertter;
        this.defaultValueGetter = defaultValueGetter;
        this.dbMetadataColumn = dbMetadataColumn;
    }

    public boolean hasColumnName() {
        String name = this.getColumnName();
        return name != null && !name.trim().isEmpty();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Object convertAndGetValue(Object value) {
        Object r = value;
        if (this.convertter != null) {
            r = this.convertter.apply(value);
        }
        return r;
    }

    public Object convertAndGetDefaultValueIfNull(Object value) {
        Object r = value;
        if (value == null) {
            if (this.defaultValueGetter != null) {
                r = this.defaultValueGetter.get();
            }
        } else if (this.convertter != null) {
            r = this.convertter.apply(value);
        }
        return r;
    }

    public DbMetadataColumn getDbMetadataColumn() {
        return this.dbMetadataColumn;
    }
}

