/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.HugeInConfig4DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.DynamicObjectCollectionBuilder;
import kd.bos.logorm.impl.LogORMStandardImpl;
import kd.bos.logorm.impl.QFilterValid;
import kd.bos.logorm.impl.QueryActionBuilder;
import kd.bos.logorm.request.QueryRequest;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;

public class LogORMDBImpl
extends LogORMStandardImpl {
    private final DataEntityMetaProvider dataEntityMetaProvider = DataEntityMetaProvider.create();

    @Override
    public long[] insert0(List<DynamicObject> objects) {
        List r = ORM.create().insert(objects);
        long[] ids = new long[r.size()];
        for (int i = 0; i < r.size(); ++i) {
            ids[i] = (Long)r.get(i);
        }
        return ids;
    }

    @Override
    public int update0(List<DynamicObject> objects) {
        if (objects == null || objects.isEmpty()) {
            return 0;
        }
        int batchCount = Math.min(HugeInConfig4DB.inMaxSize(), LogORMConfig.getDbBatchUpdateCount());
        IDataEntityType dt = objects.get(0).getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)dt);
        dataManager.setCurrentUserId((Object)RequestContext.get().getCurrUserId());
        dataManager.setOption(OperateOption.create());
        if (objects.size() <= batchCount) {
            return this.partitionUpdate(dataManager, dt, objects);
        }
        int updateCount = 0;
        List partitionObjectList = Lists.partition(objects, (int)batchCount);
        for (List dynamicObjects : partitionObjectList) {
            updateCount += this.partitionUpdate(dataManager, dt, dynamicObjects);
        }
        return updateCount;
    }

    public int partitionUpdate(IDataManager dataManager, IDataEntityType dt, List<DynamicObject> objects) {
        int updateCount;
        if (objects == null || objects.isEmpty()) {
            return 0;
        }
        String entityName = dt.getName();
        String pkProperty = dt.getPrimaryKey().getName();
        ISimpleProperty primaryKeyProperty = dt.getPrimaryKey();
        HashSet<Object> ids = new HashSet<Object>(objects.size());
        for (DynamicObject object : objects) {
            ids.add(primaryKeyProperty.getValueFast((Object)object));
        }
        QFilter qFilter = new QFilter(pkProperty, "in", (Object)ids.toArray());
        ORM orm = ORM.create();
        try (TXHandle handle = TX.requiresNew((String)"LogORM.batchUpdate");){
            updateCount = orm.count("LogORM.queryCountForUpdate", entityName, new QFilter[]{qFilter});
            dataManager.update(objects.toArray());
        }
        return updateCount;
    }

    @Override
    public int delete0(String entityName, QFilter[] where) {
        if (where != null && where.length > 0) {
            for (QFilter filter : where) {
                QFilterValid.getINSTANCE().check(filter);
            }
        }
        ORM orm = ORM.create();
        IDataEntityType dt = orm.newDynamicObject(entityName).getDataEntityType();
        String pkProperty = dt.getPrimaryKey().getName();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)dt);
        dataManager.setCurrentUserId((Object)RequestContext.get().getCurrUserId());
        dataManager.setOption(OperateOption.create());
        int deleteCount = 0;
        int batchCount = Math.min(HugeInConfig4DB.inMaxSize(), LogORMConfig.getDbBatchDeleteCount());
        while (true) {
            TXHandle handle = TX.requiresNew((String)"LogORM.queryIdForDelete");
            Throwable throwable = null;
            try {
                DataSet dataSet = orm.queryDataSet("LogORM.queryIdForDelete", entityName, pkProperty, where, null, batchCount);
                Throwable throwable2 = null;
                try {
                    int idCount = 0;
                    ArrayList<Object> ids = new ArrayList<Object>(10000);
                    for (Row row : dataSet) {
                        ids.add(row.get(pkProperty));
                        ++deleteCount;
                        ++idCount;
                    }
                    if (!ids.isEmpty()) {
                        dataManager.delete(ids.toArray());
                    }
                    if (idCount >= batchCount) continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    dataSet.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (handle == null) continue;
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                handle.close();
                continue;
            }
            break;
        }
        return deleteCount;
    }

    @Override
    public DynamicObjectCollection query0(String entityName, String selectFields, QFilter[] filters, int limit, int offset) {
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                QFilterValid.getINSTANCE().check(filter);
            }
        }
        DataSet ds = ORM.create().queryDataSet("LogORM", entityName, selectFields, filters, PresetPropertyUtils.getSortPropertyName() + " DESC", offset, limit, null);
        QueryRequest action = new QueryActionBuilder(this.dataEntityMetaProvider, entityName, selectFields, filters, limit, offset, false, null).build();
        return new DynamicObjectCollectionBuilder(entityName, this.dataEntityMetaProvider, action.getSelect(), ds).build();
    }

    @Override
    public DataSet queryDataSet0(String entityName, String selectFields, QFilter[] filters, int limit, int offset) {
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                QFilterValid.getINSTANCE().check(filter);
            }
        }
        return ORM.create().queryDataSet("LogORM", entityName, selectFields, filters, PresetPropertyUtils.getSortPropertyName() + " DESC", offset, limit, null);
    }

    @Override
    public int count0(String entityName, QFilter[] filters) {
        return ORM.create().count("LogORM", entityName, filters);
    }
}

