/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logorm.client.BulkResponse;
import kd.bos.logorm.client.Client;
import kd.bos.logorm.client.DeleteByQueryResponse;
import kd.bos.logorm.client.ElasticSearchClient;
import kd.bos.logorm.client.QueryCompletionResponse;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.impl.BatchSaveActionBuilder;
import kd.bos.logorm.impl.ClientProvider;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.DeleteActionBuilder;
import kd.bos.logorm.impl.DynamicObjectCollectionBuilder;
import kd.bos.logorm.impl.LogORMStandardImpl;
import kd.bos.logorm.impl.QueryActionBuilder;
import kd.bos.logorm.request.BatchSaveRequest;
import kd.bos.logorm.request.DeleteRequest;
import kd.bos.logorm.request.QueryRequest;
import kd.bos.logorm.request.RequestContext;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.query.QFilter;

public class LogORMElasticImpl
extends LogORMStandardImpl {
    private final Client client = new ClientProvider().get();
    private final DataEntityMetaProvider dataEntityMetaProvider = DataEntityMetaProvider.create();

    @Override
    public long[] insert0(List<DynamicObject> objects) {
        if (objects.isEmpty()) {
            return new long[0];
        }
        BulkResponse response = this.batchSplitExecute(objects, BatchSaveRequest.Operator.INSERT);
        return response.getIds();
    }

    private BulkResponse save(List<DynamicObject> objects, BatchSaveRequest.Operator operator) {
        BatchSaveRequest request = new BatchSaveActionBuilder(objects, operator, this.dataEntityMetaProvider).build();
        RequestContext context = new RequestContext(this.dataEntityMetaProvider);
        return this.client.bulk(context, request);
    }

    private BulkResponse batchSplitExecute(List<DynamicObject> objects, BatchSaveRequest.Operator operator) {
        int batchCount;
        int objectSize = objects.size();
        if (objectSize <= (batchCount = LogORMConfig.getBatchSplitCount())) {
            return this.save(objects, operator);
        }
        List shardList = Lists.partition(objects, (int)batchCount);
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>(shardList.size());
        ArrayList<String> warnings = new ArrayList<String>();
        int total = 0;
        for (List slice : shardList) {
            BulkResponse response = this.save(slice, operator);
            responses.add(response);
            warnings.addAll(response.getWarnings());
            total += response.getIds().length;
        }
        int[] result = new int[total];
        long[] ids = new long[total];
        int pos = 0;
        for (BulkResponse rsp : responses) {
            System.arraycopy(rsp.getResult(), 0, result, pos, rsp.getResult().length);
            System.arraycopy(rsp.getIds(), 0, ids, pos, rsp.getIds().length);
            pos += rsp.getIds().length;
        }
        return new BulkResponse(warnings, result, ids);
    }

    @Override
    public int update0(List<DynamicObject> objects) {
        if (objects.isEmpty()) {
            return 0;
        }
        int result = 0;
        BulkResponse bulkResult = this.batchSplitExecute(objects, BatchSaveRequest.Operator.UPDATE);
        for (int i : bulkResult.getResult()) {
            result += i;
        }
        return result;
    }

    @Override
    public int delete0(String entityName, QFilter[] where) {
        if (where == null) {
            where = new QFilter[]{};
        }
        DeleteRequest request = new DeleteActionBuilder(this.dataEntityMetaProvider, entityName, where, true).build();
        RequestContext context = new RequestContext(this.dataEntityMetaProvider);
        DeleteByQueryResponse result = this.client.delete(context, request);
        return result.getDeleted();
    }

    @Override
    public DynamicObjectCollection query0(String entityName, String selectFields, QFilter[] filters, int limit, int offset) {
        QueryRequest action = new QueryActionBuilder(this.dataEntityMetaProvider, entityName, selectFields, filters, limit, offset, this.client instanceof ElasticSearchClient, PresetPropertyUtils.getSortPropertyName() + " desc").build();
        DataSet ds = this.queryDataSet1(action);
        return new DynamicObjectCollectionBuilder(entityName, this.dataEntityMetaProvider, action.getSelect(), ds).build();
    }

    private DataSet queryDataSet1(QueryRequest request) {
        RequestContext context = new RequestContext(this.dataEntityMetaProvider);
        QueryCompletionResponse queryResult = this.client.query(context, request);
        return queryResult.getDataSet();
    }

    @Override
    public DataSet queryDataSet0(String entityName, String selectFields, QFilter[] filters, int limit, int offset) {
        QueryRequest request = new QueryActionBuilder(this.dataEntityMetaProvider, entityName, selectFields, filters, limit, offset, this.client instanceof ElasticSearchClient, PresetPropertyUtils.getSortPropertyName() + " desc").build();
        return this.queryDataSet1(request);
    }

    @Override
    public long[] save0(List<DynamicObject> objects) {
        if (objects.isEmpty()) {
            return new long[0];
        }
        BulkResponse response = this.batchSplitExecute(objects, BatchSaveRequest.Operator.SAVE);
        return response.getIds();
    }

    @Override
    public int count0(String entityName, QFilter[] filters) {
        QueryRequest request = new QueryActionBuilder(this.dataEntityMetaProvider, entityName, "count(id)", filters, 1, 0, this.client instanceof ElasticSearchClient, null).build();
        DataSet dataSet = this.queryDataSet1(request);
        if (dataSet.hasNext()) {
            return dataSet.next().getInteger(0);
        }
        return 0;
    }
}

