/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import kd.bos.logorm.LogORM;
import kd.bos.logorm.impl.LogORMDBImpl;
import kd.bos.logorm.impl.LogORMElasticImpl;

public class LogORMImplContext
implements AutoCloseable {
    private static final ThreadLocal<LogORMImplContext> CONTEXT = new ThreadLocal();
    private final StoreType storeType;
    private final LogORMImplContext parent;

    private LogORMImplContext(StoreType storeType) {
        this.storeType = storeType;
        this.parent = CONTEXT.get();
        CONTEXT.set(this);
    }

    @Override
    public void close() {
        CONTEXT.remove();
        if (this.parent != null) {
            CONTEXT.set(this.parent);
        }
    }

    public static LogORMImplContext create(StoreType storeType) {
        return new LogORMImplContext(storeType);
    }

    static LogORM get() {
        LogORMImplContext current = CONTEXT.get();
        if (current == null) {
            return null;
        }
        if (current.storeType == StoreType.Elastic) {
            return new LogORMElasticImpl();
        }
        return new LogORMDBImpl();
    }

    public static enum StoreType {
        Elastic,
        DB;

    }
}

