/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.bundle.BosRes;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.ParameterValid;
import kd.bos.logorm.utils.ObjectTypeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.oql.g.expr.SelectFields;

public class QFilterValid
implements ParameterValid<QFilter> {
    private static final QFilterValid INSTANCE = new QFilterValid();
    private final List<ParameterValid<QFilter>> validList = new ArrayList<ParameterValid<QFilter>>();

    private QFilterValid() {
        this.validList.add(new QFilterParameterValid());
        this.validList.add(new QFilterOperatorValid());
    }

    public static QFilterValid getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public void check(QFilter object) {
        object.trans(qFilter -> {
            for (ParameterValid<QFilter> valid : this.validList) {
                valid.check((QFilter)qFilter);
            }
            return qFilter;
        });
    }

    static class QFilterOperatorValid
    implements ParameterValid<QFilter> {
        private final List<String> allowOperator = new ArrayList<String>();

        public QFilterOperatorValid() {
            this.allowOperator.add("=");
            this.allowOperator.add("in");
            this.allowOperator.add("not in");
            this.allowOperator.add("!=");
            this.allowOperator.add("<>");
            this.allowOperator.add("is null");
            this.allowOperator.add("is not null");
            this.allowOperator.add(">");
            this.allowOperator.add("<");
            this.allowOperator.add(">=");
            this.allowOperator.add("<=");
            this.allowOperator.add("and");
            this.allowOperator.add("or");
            this.allowOperator.add("like");
            this.allowOperator.add("not like");
            this.allowOperator.add("ftlike");
        }

        @Override
        public void check(QFilter object) {
            if (!this.allowOperator.contains(object.getCP().toLowerCase())) {
                throw LogORMExceptionFactory.createWithContext("Unsupported qFilter cp: %s", object.getCP());
            }
        }
    }

    static class QFilterParameterValid
    implements ParameterValid<QFilter> {
        QFilterParameterValid() {
        }

        @Override
        public void check(QFilter object) {
            Object value;
            if (this.isCollectionOrArray(object.getValue()) && !"in".equalsIgnoreCase(object.getCP()) && !"not in".equalsIgnoreCase(object.getCP())) {
                throw LogORMExceptionFactory.create("QFilter value check fail,the operator is '%s' but value type is %s.", object.getCP(), ObjectTypeUtils.getTypeName(object.getValue()));
            }
            if (object.isExpressValue()) {
                throw LogORMExceptionFactory.createWithContext(BosRes.get((String)"bos-logormengine", (String)"UnsupportedExpressValue", (String)"\u4e0d\u652f\u6301\u5728\u8fc7\u6ee4\u503c\u4e2d\u5185\u5d4c\u8868\u8fbe\u5f0f\uff1a{0}\u3002", (Object[])new Object[]{object.toString()}));
            }
            SelectFields s = SelectFields.parseFrom((String)object.getProperty());
            if (s.getExpr() instanceof UnresolvedFuncall) {
                throw LogORMExceptionFactory.createWithContext(BosRes.get((String)"bos-logormengine", (String)"UnsupportedExpressProperty", (String)"\u4e0d\u652f\u6301\u5728\u8fc7\u6ee4\u5c5e\u6027\u4e2d\u5185\u5d4c\u8868\u8fbe\u5f0f\uff1a{0}\u3002", (Object[])new Object[]{object.toString()}));
            }
            if ((object.getCP().equalsIgnoreCase("like") || object.getCP().equalsIgnoreCase("not like")) && (value = object.getValue()) instanceof CharSequence && ((CharSequence)object.getValue()).length() > LogORMConfig.getMaxLikeValueLength()) {
                throw LogORMExceptionFactory.createWarn(BosRes.get((String)"bos-logormengine", (String)"LikeQueryParamTooLong", (String)"\u67e5\u8be2\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7{0}\u3002", (Object[])new Object[]{LogORMConfig.getMaxLikeValueLength()}));
            }
        }

        private boolean isCollectionOrArray(Object value) {
            if (value == null) {
                return false;
            }
            if (value.getClass().isArray()) {
                return true;
            }
            return value instanceof Iterable;
        }
    }
}

