/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.impl;

import java.util.List;
import java.util.regex.Pattern;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.FtLike2QFilter;
import kd.bos.logorm.impl.QFilterProperty2ColumnName;
import kd.bos.logorm.impl.QFilterValid;
import kd.bos.logorm.request.QueryRequest;
import kd.bos.logorm.utils.PresetPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.oql.g.expr.OrderBys;
import kd.bos.orm.query.oql.g.expr.SelectFields;

public class QueryActionBuilder {
    private static final Pattern FIELD_NAME_CHECK = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    private final QFilterValid qFilterValid = QFilterValid.getINSTANCE();
    private final DataEntityMetaProvider dataEntityMetaProvider;
    private final String entityName;
    private final String selectFields;
    private final QFilter[] filters;
    private final int limit;
    private final int offset;
    private final boolean esClient;
    private final String orderBys;

    public QueryActionBuilder(DataEntityMetaProvider dataEntityMetaProvider, String entityName, String selectFields, QFilter[] filters, int limit, int offset, boolean esClient, String orderBys) {
        this.entityName = entityName;
        this.selectFields = selectFields;
        this.filters = filters;
        this.limit = limit;
        this.offset = offset;
        this.dataEntityMetaProvider = dataEntityMetaProvider;
        this.esClient = esClient;
        this.orderBys = orderBys;
    }

    public QueryRequest build() {
        SelectFields s = SelectFields.parseFrom((String)this.selectFields);
        List propertyFields = s.createPropertyFields(this.entityName);
        EntityMetadataContext metadata = this.dataEntityMetaProvider.getEntityMetadata(this.entityName);
        QueryRequest.SelectItem[] select = new QueryRequest.SelectItem[propertyFields.size()];
        QueryRequest.OrderByItem[] orderByItems = new QueryRequest.OrderByItem[]{};
        if (this.orderBys != null) {
            orderByItems = this.buildOrderBys(this.orderBys, metadata);
        }
        for (int i = 0; i < propertyFields.size(); ++i) {
            QueryRequest.SelectItem selectItem;
            PropertyField propertyField = (PropertyField)propertyFields.get(i);
            String propertyName = propertyField.getName().trim();
            if (propertyField.getAlias() != null && !propertyField.getAlias().trim().equals("")) {
                propertyName = propertyField.getAlias().trim();
            }
            select[i] = selectItem = new QueryRequest.SelectItem(propertyName, propertyField.toSingleTableSelectField(true, metadata::getPropertyField));
        }
        QFilter[] where = null;
        if (this.filters != null) {
            where = new QFilter[this.filters.length];
            for (int i = 0; i < this.filters.length; ++i) {
                where[i] = this.qFilterReBuilder(this.filters[i].copy(), metadata, this.entityName);
            }
        }
        String optDatePropertyName = metadata.getEntityProperty(PresetPropertyUtils.getSortPropertyName()).getColumnName();
        return new QueryRequest(this.entityName, select, metadata.getTableName(), where, this.offset, this.limit, orderByItems, optDatePropertyName);
    }

    private QueryRequest.OrderByItem[] buildOrderBys(String orderBys, EntityMetadataContext metadata) {
        List orderByInfos = OrderBys.parseFrom((String)orderBys).createOrderInfos("");
        QueryRequest.OrderByItem[] orderByItems = new QueryRequest.OrderByItem[orderByInfos.size()];
        for (int i = 0; i < orderByInfos.size(); ++i) {
            OrderByInfo orderByInfo = (OrderByInfo)orderByInfos.get(i);
            String propertyName = orderByInfo.getPropertySegExpress().toString();
            String columnName = orderByInfo.getPropertySegExpress().toSingleTableString(false, metadata::getPropertyField);
            orderByItems[i] = new QueryRequest.OrderByItem(propertyName, columnName, orderByInfo.getOrdering());
        }
        return orderByItems;
    }

    private QFilter qFilterReBuilder(QFilter filter, EntityMetadataContext metadata, String entityName) {
        QFilter qFilter = new FtLike2QFilter().trans(filter, metadata);
        this.qFilterValid.check(qFilter);
        qFilter = new QFilterProperty2ColumnName(metadata, entityName, this.esClient).trans(qFilter);
        return qFilter;
    }
}

