/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.metric;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FixedLengthSortList<E extends Comparable<E>> {
    private List<E> list;
    private int top = 10;
    private int resort = 100;

    public FixedLengthSortList() {
        this.list = Collections.synchronizedList(new ArrayList(this.resort));
    }

    public FixedLengthSortList(int top, int resort) {
        this.top = top;
        this.resort = resort;
        if (this.resort <= this.top) {
            this.resort = this.top * 10;
        }
        this.list = Collections.synchronizedList(new ArrayList(this.resort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E item) {
        if (this.list.size() >= this.resort) {
            FixedLengthSortList fixedLengthSortList = this;
            synchronized (fixedLengthSortList) {
                List bak = this.list;
                this.list = Collections.synchronizedList(new ArrayList(this.resort));
                bak.sort(Comparator.reverseOrder());
                this.list.addAll(bak.subList(0, this.top));
            }
        }
        this.list.add(item);
    }

    public List<E> getTop() {
        ArrayList bak = new ArrayList(this.list);
        bak.sort(Comparator.reverseOrder());
        int end = Math.min(bak.size(), this.top);
        if (end == 0) {
            return new ArrayList(0);
        }
        return bak.subList(0, end);
    }
}

