/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.metric;

import kd.bos.metric.Histogram;
import kd.bos.util.DisCardUtil;

public class LogORMCostMetric
implements AutoCloseable {
    private final long start = System.currentTimeMillis();
    private final Histogram histogram;
    private Listener[] listeners;
    private long cost = -1L;

    public LogORMCostMetric(Histogram histogram) {
        this.histogram = histogram;
    }

    public LogORMCostMetric(Histogram histogram, Listener ... listeners) {
        this.histogram = histogram;
        this.listeners = listeners;
    }

    @Override
    public void close() {
        long end = System.currentTimeMillis();
        if (end >= this.start) {
            this.cost = end - this.start;
        }
        if (this.cost >= 0L) {
            try {
                this.histogram.update((int)this.cost);
            }
            catch (Exception ignored) {
                DisCardUtil.discard();
            }
        }
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                try {
                    listener.onClosed(this);
                }
                catch (Exception ignored) {
                    DisCardUtil.discard();
                }
            }
        }
    }

    public long getCost() {
        return this.cost;
    }

    static interface Listener {
        public void onClosed(LogORMCostMetric var1);
    }
}

