/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logorm.metric;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.metric.LogORMMXBean;
import kd.bos.logorm.metric.LogORMMetricServiceImpl;
import kd.bos.logorm.metric.QuerySlowSnapshot;
import kd.bos.metric.Snapshot;

public class LogORMMXBeanImpl
implements LogORMMXBean {
    private static final Log log = LogFactory.getLog(LogORMMXBeanImpl.class);
    private final LogORMMetricServiceImpl metricService;

    public LogORMMXBeanImpl(LogORMMetricServiceImpl metricService) {
        this.metricService = metricService;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("kd.bos.logorm:name=logorm"));
        }
        catch (Exception e) {
            log.warn("register LogORMMXBeanImpl MXBean error,msg:{}.", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public Snapshot getQueryCost() {
        return this.metricService.getQueryHistogram().getSnapshot();
    }

    @Override
    public Snapshot getInsertCost() {
        return this.metricService.getInsertHistogram().getSnapshot();
    }

    @Override
    public Snapshot getUpdateCost() {
        return this.metricService.getUpdateHistogram().getSnapshot();
    }

    @Override
    public Snapshot getDeleteCost() {
        return this.metricService.getDeleteHistogram().getSnapshot();
    }

    @Override
    public List<QuerySlowSnapshot> getQuerySlowTop10() {
        return this.metricService.getSlowQueryTop10();
    }
}

